/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.dtable;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.v1_1.ContextEntry;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionRule;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionTableOrientation;
import org.kie.workbench.common.dmn.api.definition.v1_1.Definitions;
import org.kie.workbench.common.dmn.api.definition.v1_1.HitPolicy;
import org.kie.workbench.common.dmn.api.definition.v1_1.InputClause;
import org.kie.workbench.common.dmn.api.definition.v1_1.InputData;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.v1_1.OutputClause;
import org.kie.workbench.common.dmn.api.definition.v1_1.UnaryTests;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorModelEnricher;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionTableDefaultValueUtilities;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;

@ApplicationScoped
public class DecisionTableEditorDefinitionEnricher
implements ExpressionEditorModelEnricher<DecisionTable> {
    private SessionManager sessionManager;
    private DMNGraphUtils dmnGraphUtils;

    public DecisionTableEditorDefinitionEnricher() {
    }

    @Inject
    public DecisionTableEditorDefinitionEnricher(SessionManager sessionManager, DMNGraphUtils dmnGraphUtils) {
        this.sessionManager = sessionManager;
        this.dmnGraphUtils = dmnGraphUtils;
    }

    @Override
    public void enrich(Optional<String> nodeUUID, Optional<DecisionTable> expression) {
        expression.ifPresent(dtable -> {
            dtable.setHitPolicy(HitPolicy.ANY);
            dtable.setPreferredOrientation(DecisionTableOrientation.RULE_AS_ROW);
            InputClause inputClause = new InputClause();
            LiteralExpression literalExpression = new LiteralExpression();
            literalExpression.setText(DecisionTableDefaultValueUtilities.getNewInputClauseName(dtable));
            inputClause.setInputExpression(literalExpression);
            dtable.getInput().add(inputClause);
            OutputClause outputClause = new OutputClause();
            outputClause.setName(DecisionTableDefaultValueUtilities.getNewOutputClauseName(dtable));
            dtable.getOutput().add(outputClause);
            DecisionRule decisionRule = new DecisionRule();
            UnaryTests decisionRuleUnaryTest = new UnaryTests();
            decisionRuleUnaryTest.setText("");
            decisionRule.getInputEntry().add(decisionRuleUnaryTest);
            LiteralExpression decisionRuleLiteralExpression = new LiteralExpression();
            decisionRuleLiteralExpression.setText("");
            decisionRule.getOutputEntry().add(decisionRuleLiteralExpression);
            Description description = new Description();
            description.setValue("");
            decisionRule.setDescription(description);
            dtable.getRule().add(decisionRule);
            inputClause.setParent((DMNModelInstrumentedBase)dtable);
            outputClause.setParent((DMNModelInstrumentedBase)dtable);
            decisionRule.setParent((DMNModelInstrumentedBase)dtable);
            literalExpression.setParent((DMNModelInstrumentedBase)inputClause);
            decisionRuleUnaryTest.setParent((DMNModelInstrumentedBase)decisionRule);
            decisionRuleLiteralExpression.setParent((DMNModelInstrumentedBase)decisionRule);
            if (nodeUUID.isPresent()) {
                this.enrichInputClauses((String)nodeUUID.get(), (DecisionTable)dtable);
            } else {
                this.enrichOutputClauses((DecisionTable)dtable);
            }
        });
    }

    void enrichInputClauses(String uuid, DecisionTable dtable) {
        Graph graph = this.sessionManager.getCurrentSession().getCanvasHandler().getDiagram().getGraph();
        Node node = graph.getNode(uuid);
        if (Objects.isNull(node)) {
            return;
        }
        List<InputData> inputDataSet = node.getInEdges().stream().map(Edge::getSourceNode).map(Element::getContent).filter(content -> content instanceof Definition).map(content -> (Definition)content).map(Definition::getDefinition).filter(definition -> definition instanceof InputData).map(definition -> (InputData)definition).collect(Collectors.toList());
        if (inputDataSet.isEmpty()) {
            return;
        }
        Definitions definitions = this.dmnGraphUtils.getDefinitions();
        ArrayList inputClauseRequirements = new ArrayList();
        inputDataSet.forEach(inputData -> this.addInputClauseRequirement(inputData.getVariable().getTypeRef(), definitions, inputClauseRequirements, inputData.getName().getValue()));
        dtable.getInput().clear();
        dtable.getRule().stream().forEach(decisionRule -> decisionRule.getInputEntry().clear());
        inputClauseRequirements.stream().sorted(Comparator.comparing(inputClauseRequirement -> ((InputClauseRequirement)inputClauseRequirement).text)).forEach(inputClauseRequirement -> {
            InputClause inputClause = new InputClause();
            LiteralExpression literalExpression = new LiteralExpression();
            literalExpression.setText(((InputClauseRequirement)inputClauseRequirement).text);
            literalExpression.setTypeRef(((InputClauseRequirement)inputClauseRequirement).typeRef);
            inputClause.setInputExpression(literalExpression);
            dtable.getInput().add(inputClause);
            dtable.getRule().stream().forEach(decisionRule -> {
                UnaryTests decisionRuleUnaryTest = new UnaryTests();
                decisionRuleUnaryTest.setText("");
                decisionRule.getInputEntry().add(decisionRuleUnaryTest);
                decisionRuleUnaryTest.setParent((DMNModelInstrumentedBase)decisionRule);
            });
            inputClause.setParent((DMNModelInstrumentedBase)dtable);
            literalExpression.setParent((DMNModelInstrumentedBase)inputClause);
        });
    }

    private void addInputClauseRequirement(QName typeRef, Definitions definitions, List<InputClauseRequirement> inputClauseRequirements, String text) {
        if ("".equals(typeRef.getNamespaceURI()) && "".equals(typeRef.getPrefix())) {
            definitions.getItemDefinition().stream().filter(itemDef -> itemDef.getName().getValue().equals(typeRef.getLocalPart())).findFirst().ifPresent(itemDefinition -> itemDefinition.getItemComponent().forEach(itemDefinitionComponent -> this.addInputClauseRequirement(itemDefinitionComponent.getTypeRef(), definitions, inputClauseRequirements, text + "." + itemDefinitionComponent.getName().getValue())));
        } else {
            inputClauseRequirements.add(new InputClauseRequirement(text, typeRef));
        }
    }

    void enrichOutputClauses(DecisionTable dtable) {
        if (dtable.getParent() instanceof ContextEntry) {
            ContextEntry contextEntry = (ContextEntry)dtable.getParent();
            dtable.getOutput().clear();
            dtable.getRule().stream().forEach(decisionRule -> decisionRule.getOutputEntry().clear());
            OutputClause outputClause = new OutputClause();
            outputClause.setName(contextEntry.getVariable().getName().getValue());
            dtable.getOutput().add(outputClause);
            dtable.getRule().stream().forEach(decisionRule -> {
                LiteralExpression decisionRuleLiteralExpression = new LiteralExpression();
                decisionRuleLiteralExpression.setText("");
                decisionRule.getOutputEntry().add(decisionRuleLiteralExpression);
                decisionRuleLiteralExpression.setParent((DMNModelInstrumentedBase)decisionRule);
            });
            outputClause.setParent((DMNModelInstrumentedBase)dtable);
        }
    }

    private static class InputClauseRequirement {
        private String text;
        private QName typeRef;

        public InputClauseRequirement(String text, QName typeRef) {
            this.text = text;
            this.typeRef = typeRef;
        }
    }
}

