/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.function;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.dmn.api.definition.v1_1.FunctionDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.FunctionGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.KindUtilities;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.parameters.HasParametersControl;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.parameters.ParametersPopoverView;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.EditablePopupHeaderMetaData;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;

public class FunctionColumnParametersHeaderMetaData
extends EditablePopupHeaderMetaData<HasParametersControl, ParametersPopoverView.Presenter> {
    static final String PARAMETER_COLUMN_GROUP = "FunctionColumnParametersHeaderMetaData$Parameters";
    private final Supplier<FunctionDefinition> functionSupplier;
    private final FunctionGrid gridWidget;
    private final TranslationService translationService;

    public FunctionColumnParametersHeaderMetaData(Supplier<FunctionDefinition> functionSupplier, TranslationService translationService, CellEditorControlsView.Presenter cellEditorControls, ParametersPopoverView.Presenter editor, Optional<String> editorTitle, FunctionGrid gridWidget) {
        super(cellEditorControls, editor, editorTitle);
        this.functionSupplier = functionSupplier;
        this.translationService = translationService;
        this.gridWidget = gridWidget;
    }

    @Override
    protected HasParametersControl getPresenter() {
        return this.gridWidget;
    }

    public String getColumnGroup() {
        return PARAMETER_COLUMN_GROUP;
    }

    public String getTitle() {
        StringBuilder sb = new StringBuilder(this.getExpressionLanguageTitle());
        sb.append(" : ");
        sb.append(this.getFormalParametersTitle());
        return sb.toString();
    }

    String getExpressionLanguageTitle() {
        FunctionDefinition.Kind kind = KindUtilities.getKind(this.functionSupplier.get());
        return kind == null ? this.translationService.getTranslation("FunctionEditor.Undefined") : kind.code();
    }

    String getFormalParametersTitle() {
        List formalParameters = this.functionSupplier.get().getFormalParameter();
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        if (!formalParameters.isEmpty()) {
            sb.append(formalParameters.stream().map(ii -> ii.getName().getValue()).collect(Collectors.joining(", ")));
        }
        sb.append(")");
        return sb.toString();
    }
}

