/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.function.parameters;

import java.util.List;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.parameters.HasParametersControl;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.parameters.ParametersPopoverView;

@ApplicationScoped
public class ParametersPopoverImpl
implements ParametersPopoverView.Presenter {
    private ParametersPopoverView view;
    private Optional<HasParametersControl> binding = Optional.empty();

    public ParametersPopoverImpl() {
    }

    @Inject
    public ParametersPopoverImpl(ParametersPopoverView view) {
        this.view = view;
        view.init(this);
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    @Override
    public void bind(HasParametersControl bound, int uiRowIndex, int uiColumnIndex) {
        this.binding = Optional.ofNullable(bound);
        this.binding.ifPresent(b -> this.view.setParameters(b.getParameters()));
    }

    private void refresh() {
        this.binding.ifPresent(b -> {
            this.view.setParameters(b.getParameters());
            this.focusLastParameter((HasParametersControl)b);
        });
    }

    @Override
    public void show(Optional<String> editorTitle) {
        this.binding.ifPresent(b -> {
            this.view.show(editorTitle);
            this.focusLastParameter((HasParametersControl)b);
        });
    }

    private void focusLastParameter(HasParametersControl hasParameters) {
        List<InformationItem> parameters = hasParameters.getParameters();
        if (!parameters.isEmpty()) {
            this.view.focusParameter(parameters.size() - 1);
        }
    }

    @Override
    public void hide() {
        this.binding.ifPresent(b -> this.view.hide());
    }

    @Override
    public void addParameter() {
        this.binding.ifPresent(b -> b.addParameter(this::refresh));
    }

    @Override
    public void removeParameter(InformationItem parameter) {
        this.binding.ifPresent(b -> b.removeParameter(parameter, this::refresh));
    }

    @Override
    public void updateParameterName(InformationItem parameter, String name) {
        this.binding.ifPresent(b -> b.updateParameterName(parameter, name));
    }
}

