/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.relation;

import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem;
import org.kie.workbench.common.dmn.api.definition.v1_1.List;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.v1_1.Relation;
import org.kie.workbench.common.dmn.client.editors.expressions.types.BaseEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionType;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationDefaultValueUtilities;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationGridData;
import org.kie.workbench.common.dmn.client.editors.types.NameAndDataTypePopoverView;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.dmn.client.widgets.grid.model.ExpressionEditorChanged;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.session.Session;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;

@ApplicationScoped
public class RelationEditorDefinition
extends BaseEditorDefinition<Relation, RelationGridData> {
    private NameAndDataTypePopoverView.Presenter headerEditor;

    public RelationEditorDefinition() {
    }

    @Inject
    public RelationEditorDefinition(DefinitionUtils definitionUtils, SessionManager sessionManager, @Session SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory, Event<ExpressionEditorChanged> editorSelectedEvent, Event<RefreshFormPropertiesEvent> refreshFormPropertiesEvent, Event<DomainObjectSelectionEvent> domainObjectSelectionEvent, ListSelectorView.Presenter listSelector, TranslationService translationService, NameAndDataTypePopoverView.Presenter headerEditor) {
        super(definitionUtils, sessionManager, sessionCommandManager, canvasCommandFactory, editorSelectedEvent, refreshFormPropertiesEvent, domainObjectSelectionEvent, listSelector, translationService);
        this.headerEditor = headerEditor;
    }

    @Override
    public ExpressionType getType() {
        return ExpressionType.RELATION;
    }

    @Override
    public String getName() {
        return this.translationService.format("ExpressionEditor.RelationType", new Object[0]);
    }

    @Override
    public Optional<Relation> getModelClass() {
        return Optional.of(new Relation());
    }

    @Override
    public void enrich(Optional<String> nodeUUID, Optional<Relation> expression) {
        expression.ifPresent(relation -> {
            InformationItem column = new InformationItem();
            column.getName().setValue(RelationDefaultValueUtilities.getNewColumnName(relation));
            List row = new List();
            LiteralExpression literalExpression = new LiteralExpression();
            row.getExpression().add(literalExpression);
            relation.getColumn().add(column);
            relation.getRow().add(row);
            column.setParent((DMNModelInstrumentedBase)relation);
            row.setParent((DMNModelInstrumentedBase)relation);
            literalExpression.setParent((DMNModelInstrumentedBase)row);
        });
    }

    @Override
    public Optional<BaseExpressionGrid> getEditor(GridCellTuple parent, Optional<String> nodeUUID, HasExpression hasExpression, Optional<Relation> expression, Optional<HasName> hasName, int nesting) {
        return Optional.of(new RelationGrid(parent, nodeUUID, hasExpression, expression, hasName, this.getGridPanel(), this.getGridLayer(), (RelationGridData)this.makeGridData((Optional)expression), this.definitionUtils, this.sessionManager, (SessionCommandManager<AbstractCanvasHandler>)this.sessionCommandManager, (CanvasCommandFactory<AbstractCanvasHandler>)this.canvasCommandFactory, (Event<ExpressionEditorChanged>)this.editorSelectedEvent, (Event<RefreshFormPropertiesEvent>)this.refreshFormPropertiesEvent, (Event<DomainObjectSelectionEvent>)this.domainObjectSelectionEvent, this.getCellEditorControls(), this.listSelector, this.translationService, nesting, this.headerEditor));
    }

    @Override
    protected RelationGridData makeGridData(Optional<Relation> expression) {
        return new RelationGridData(new DMNGridData(), this.sessionManager, (SessionCommandManager<AbstractCanvasHandler>)this.sessionCommandManager, expression, this.getGridLayer()::batch);
    }
}

