/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types;

import com.google.gwt.regexp.shared.MatchResult;
import com.google.gwt.regexp.shared.RegExp;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.property.dmn.QName;

@Dependent
public class QNameConverter {
    private static final String QNAME_URI = "@1";
    private static final String QNAME_LOCALPART = "@2";
    private static final String QNAME_PREFIX = "@3";
    private static final String QNAME_ENCODING = "[@1][@2][@3]";
    protected static final String QNAME_DECODING_PATTERN = "^\\[(.*?)\\]\\[(.*?)\\]\\[(.*?)\\]$";
    private DMNModelInstrumentedBase dmnModel;

    public void setDMNModel(DMNModelInstrumentedBase dmnModel) {
        this.dmnModel = dmnModel;
    }

    public QName toModelValue(String componentValue) {
        try {
            List<String> matches = this.getRegexGroups(componentValue);
            if (matches.size() == 4) {
                String namespace = matches.get(1);
                String localPart = matches.get(2);
                String prefix = matches.get(3);
                return new QName(namespace, localPart, prefix);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Encoded form '" + componentValue + "' did not match '" + QNAME_DECODING_PATTERN + "'. Unable to convert to Model value.");
    }

    protected List<String> getRegexGroups(String componentValue) {
        ArrayList<String> regExGroups = new ArrayList<String>();
        RegExp p = RegExp.compile((String)QNAME_DECODING_PATTERN);
        MatchResult m = p.exec(componentValue);
        for (int i = 0; i < m.getGroupCount(); ++i) {
            regExGroups.add(m.getGroup(i));
        }
        return regExGroups;
    }

    public String toWidgetValue(QName modelValue) {
        Optional nsPrefix;
        String encoding = QNAME_ENCODING;
        String namespace = modelValue.getNamespaceURI();
        String localPart = modelValue.getLocalPart();
        String prefix = modelValue.getPrefix();
        if (this.dmnModel != null && (nsPrefix = this.dmnModel.getPrefixForNamespaceURI(namespace)).isPresent()) {
            prefix = (String)nsPrefix.get();
            namespace = "";
        }
        encoding = encoding.replaceFirst(QNAME_URI, namespace);
        encoding = encoding.replaceFirst(QNAME_LOCALPART, localPart);
        encoding = encoding.replaceFirst(QNAME_PREFIX, prefix);
        return encoding;
    }
}

