/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview;

import elemental2.dom.HTMLElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManager;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListItem;
import org.uberfire.client.mvp.UberElemental;

@ApplicationScoped
public class DataTypeList {
    private final View view;
    private final ManagedInstance<DataTypeListItem> listItems;
    private final DataTypeManager dataTypeManager;
    private List<DataTypeListItem> items;

    @Inject
    public DataTypeList(View view, ManagedInstance<DataTypeListItem> listItems, DataTypeManager dataTypeManager) {
        this.view = view;
        this.listItems = listItems;
        this.dataTypeManager = dataTypeManager;
    }

    @PostConstruct
    void setup() {
        this.view.init(this);
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    public void setupItems(List<DataType> dataTypes) {
        this.setListItems(this.makeDataTypeListItems(dataTypes));
        this.setupViewItems();
        this.collapseItemsInTheFirstLevel();
    }

    List<DataTypeListItem> makeDataTypeListItems(List<DataType> dataTypes) {
        ArrayList<DataTypeListItem> listItems = new ArrayList<DataTypeListItem>();
        dataTypes.forEach(dt -> listItems.addAll(this.makeTreeListItems((DataType)dt, 1)));
        return listItems;
    }

    void refreshSubItemsFromListItem(DataTypeListItem listItem, List<DataType> subDataTypes) {
        DataType dataType = listItem.getDataType();
        int level = listItem.getLevel();
        ArrayList<DataTypeListItem> gridItems = new ArrayList<DataTypeListItem>();
        for (DataType subDataType : subDataTypes) {
            gridItems.addAll(this.makeTreeListItems(subDataType, level + 1));
        }
        this.refreshItemsList(subDataTypes, gridItems);
        this.view.addSubItems(dataType, gridItems);
    }

    List<DataTypeListItem> makeTreeListItems(DataType dataType, int level) {
        DataTypeListItem listItem = this.makeListItem();
        List<DataType> subDataTypes = dataType.getSubDataTypes();
        ArrayList<DataTypeListItem> gridItems = new ArrayList<DataTypeListItem>();
        listItem.setupDataType(dataType, level);
        gridItems.add(listItem);
        for (DataType subDataType : subDataTypes) {
            gridItems.addAll(this.makeTreeListItems(subDataType, level + 1));
        }
        return gridItems;
    }

    DataTypeListItem makeListItem() {
        DataTypeListItem listItem = (DataTypeListItem)this.listItems.get();
        listItem.init(this);
        return listItem;
    }

    void refreshItemsList(List<DataType> subDataTypes, List<DataTypeListItem> gridItems) {
        this.getItems().removeIf(item -> subDataTypes.stream().anyMatch(dataType -> Objects.equals(item.getDataType().getUUID(), dataType.getUUID())));
        this.getItems().addAll(gridItems);
    }

    void removeItem(DataType dataType) {
        this.view.removeItem(dataType);
    }

    void refreshItemsByUpdatedDataTypes(List<DataType> updateDataTypes) {
        for (DataType dataType : updateDataTypes) {
            this.findItem(dataType).ifPresent(listItem -> {
                listItem.refresh();
                this.refreshSubItemsFromListItem((DataTypeListItem)listItem, dataType.getSubDataTypes());
            });
        }
    }

    Optional<DataTypeListItem> findItem(DataType dataType) {
        return this.getItems().stream().filter(item -> Objects.equals(item.getDataType().getUUID(), dataType.getUUID())).findFirst();
    }

    void setupViewItems() {
        this.view.setupListItems(this.getItems());
    }

    List<DataTypeListItem> getItems() {
        return this.items;
    }

    void setListItems(List<DataTypeListItem> items) {
        this.items = items;
    }

    void collapseItemsInTheFirstLevel() {
        this.getItems().stream().filter(typeListItem -> typeListItem.getLevel() == 1).forEach(DataTypeListItem::collapse);
    }

    void addDataType() {
        DataType dataType = this.dataTypeManager.fromNew().get();
        DataTypeListItem listItem = this.makeListItem(dataType);
        dataType.create();
        this.view.addSubItem(listItem);
        listItem.enableEditMode();
    }

    public void insertBelow(DataType dataType, DataType reference) {
        this.view.insertBelow(this.makeListItem(dataType), reference);
    }

    public void insertAbove(DataType dataType, DataType reference) {
        this.view.insertAbove(this.makeListItem(dataType), reference);
    }

    DataTypeListItem makeListItem(DataType dataType) {
        DataTypeListItem listItem = this.makeListItem();
        listItem.setupDataType(dataType, 1);
        this.getItems().add(listItem);
        return listItem;
    }

    public static interface View
    extends UberElemental<DataTypeList>,
    IsElement {
        public void setupListItems(List<DataTypeListItem> var1);

        public void addSubItems(DataType var1, List<DataTypeListItem> var2);

        public void addSubItem(DataTypeListItem var1);

        public void removeItem(DataType var1);

        public void insertBelow(DataTypeListItem var1, DataType var2);

        public void insertAbove(DataTypeListItem var1, DataType var2);
    }
}

