/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview;

import elemental2.dom.HTMLElement;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManager;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeList;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeSelect;
import org.kie.workbench.common.dmn.client.editors.types.persistence.CreationType;
import org.uberfire.client.mvp.UberElemental;

public class DataTypeListItem {
    private final View view;
    private final DataTypeSelect dataTypeSelectComponent;
    private final DataTypeManager dataTypeManager;
    private DataType dataType;
    private int level;
    private DataTypeList dataTypeList;
    private String oldName;
    private String oldType;

    @Inject
    public DataTypeListItem(View view, DataTypeSelect dataTypeSelectComponent, DataTypeManager dataTypeManager) {
        this.view = view;
        this.dataTypeSelectComponent = dataTypeSelectComponent;
        this.dataTypeManager = dataTypeManager;
    }

    @PostConstruct
    void setup() {
        this.view.init(this);
    }

    public void init(DataTypeList dataTypeList) {
        this.dataTypeList = dataTypeList;
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    DataTypeListItem setupDataType(DataType dataType, int level) {
        this.dataType = dataType;
        this.level = level;
        this.setupSelectComponent();
        this.setupView();
        return this;
    }

    void setupSelectComponent() {
        this.dataTypeSelectComponent.init(this, this.getDataType());
    }

    void setupView() {
        this.view.setupSelectComponent(this.dataTypeSelectComponent);
        this.view.setDataType(this.getDataType());
    }

    void refresh() {
        this.dataTypeSelectComponent.refresh();
        this.dataTypeSelectComponent.init(this, this.getDataType());
        this.view.setName(this.getDataType().getName());
    }

    DataType getDataType() {
        return this.dataType;
    }

    public int getLevel() {
        return this.level;
    }

    void expandOrCollapseSubTypes() {
        if (this.view.isCollapsed()) {
            this.expand();
        } else {
            this.collapse();
        }
    }

    void expand() {
        this.view.expand();
    }

    void collapse() {
        this.view.collapse();
    }

    public void refreshSubItems(List<DataType> dataTypes) {
        this.dataTypeList.refreshSubItemsFromListItem(this, dataTypes);
        this.view.enableFocusMode();
        this.view.toggleArrow(!dataTypes.isEmpty());
    }

    void enableEditMode() {
        this.oldName = this.getDataType().getName();
        this.oldType = this.getDataType().getType();
        this.view.showSaveButton();
        this.view.showDataTypeNameInput();
        this.view.enableFocusMode();
        this.dataTypeSelectComponent.enableEditMode();
    }

    void disableEditMode() {
        this.discardNewDataType();
        this.closeEditMode();
    }

    void saveAndCloseEditMode() {
        DataType updatedDataType = this.update(this.getDataType());
        if (updatedDataType.isValid()) {
            List<DataType> updatedDataTypes = this.persist(updatedDataType);
            this.dataTypeList.refreshItemsByUpdatedDataTypes(updatedDataTypes);
            this.closeEditMode();
        }
    }

    List<DataType> persist(DataType dataType) {
        return this.dataTypeManager.from(dataType).withSubDataTypes(this.dataTypeSelectComponent.getSubDataTypes()).get().update();
    }

    void discardNewDataType() {
        this.view.setDataType(this.dataTypeManager.withDataType(this.getDataType()).withName(this.getOldName()).withType(this.getOldType()).get());
        this.setupSelectComponent();
        this.refreshSubItems(this.getDataType().getSubDataTypes());
    }

    void closeEditMode() {
        this.view.showEditButton();
        this.view.hideDataTypeNameInput();
        this.view.disableFocusMode();
        this.dataTypeSelectComponent.disableEditMode();
    }

    public void remove() {
        List<DataType> destroyedDataTypes = this.getDataType().destroy();
        List<DataType> removedDataTypes = this.removeTopLevelDataTypes(destroyedDataTypes);
        destroyedDataTypes.removeAll(removedDataTypes);
        this.dataTypeList.refreshItemsByUpdatedDataTypes(destroyedDataTypes);
    }

    List<DataType> removeTopLevelDataTypes(List<DataType> destroyedDataTypes) {
        String destroyedType = this.getDataType().getName();
        return destroyedDataTypes.stream().filter(dt -> dt.isTopLevel() && (Objects.equals(dt.getName(), destroyedType) || Objects.equals(dt.getType(), destroyedType))).peek(this.dataTypeList::removeItem).collect(Collectors.toList());
    }

    DataType update(DataType dataType) {
        return this.dataTypeManager.from(dataType).withName(this.view.getName()).withType(this.dataTypeSelectComponent.getValue()).get();
    }

    String getOldName() {
        return this.oldName;
    }

    String getOldType() {
        return this.oldType;
    }

    DataTypeList getDataTypeList() {
        return this.dataTypeList;
    }

    void insertFieldAbove() {
        this.closeEditMode();
        DataType newDataType = this.newDataType();
        List<DataType> updatedDataTypes = newDataType.create(this.getDataType(), CreationType.ABOVE);
        if (newDataType.isTopLevel()) {
            this.dataTypeList.insertAbove(newDataType, this.getDataType());
        } else {
            this.dataTypeList.refreshItemsByUpdatedDataTypes(updatedDataTypes);
        }
    }

    void insertFieldBelow() {
        this.closeEditMode();
        DataType newDataType = this.newDataType();
        List<DataType> updatedDataTypes = newDataType.create(this.getDataType(), CreationType.BELOW);
        if (newDataType.isTopLevel()) {
            this.dataTypeList.insertBelow(newDataType, this.getDataType());
        } else {
            this.dataTypeList.refreshItemsByUpdatedDataTypes(updatedDataTypes);
        }
    }

    void insertNestedField() {
        this.closeEditMode();
        this.expand();
        List<DataType> updatedDataTypes = this.newDataType().create(this.getDataType(), CreationType.NESTED);
        this.dataTypeList.refreshItemsByUpdatedDataTypes(updatedDataTypes);
    }

    private DataType newDataType() {
        return this.dataTypeManager.fromNew().get();
    }

    public static interface View
    extends UberElemental<DataTypeListItem> {
        public void setDataType(DataType var1);

        public void toggleArrow(boolean var1);

        public void expand();

        public void collapse();

        public void showEditButton();

        public void showSaveButton();

        public void setupSelectComponent(DataTypeSelect var1);

        public boolean isCollapsed();

        public void hideDataTypeNameInput();

        public void showDataTypeNameInput();

        public void enableFocusMode();

        public void disableFocusMode();

        public String getName();

        public void setName(String var1);
    }
}

