/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview;

import com.google.gwt.event.dom.client.ClickEvent;
import elemental2.dom.CSSProperties;
import elemental2.dom.Element;
import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLInputElement;
import elemental2.dom.Node;
import elemental2.dom.NodeList;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.HiddenHelper;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListItem;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeSelect;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.KebabMenuInitializer;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.ListItemViewCssHelper;

@Dependent
@Templated
public class DataTypeListItemView
implements DataTypeListItem.View {
    public static final String UUID_ATTR = "data-row-uuid";
    public static final String NAME_DATA_FIELD = "name-input";
    static final String PARENT_UUID_ATTR = "data-parent-row-uuid";
    static final String ARROW_BUTTON_SELECTOR = "[data-field=\"arrow-button\"]";
    private static final int PIXELS_PER_LEVEL = 35;
    @DataField(value="view")
    private final HTMLDivElement view;
    @DataField(value="level")
    private final HTMLElement level;
    @DataField(value="arrow-button")
    private final HTMLElement arrow;
    @DataField(value="name-text")
    private final HTMLElement nameText;
    @DataField(value="name-input")
    private final HTMLInputElement nameInput;
    @DataField(value="type")
    private final HTMLElement type;
    @DataField(value="edit-button")
    private final HTMLButtonElement editButton;
    @DataField(value="save-button")
    private final HTMLButtonElement saveButton;
    @DataField(value="close-button")
    private final HTMLButtonElement closeButton;
    @DataField(value="remove-button")
    private final HTMLAnchorElement removeButton;
    @DataField(value="insert-field-above")
    private final HTMLAnchorElement insertFieldAbove;
    @DataField(value="insert-field-below")
    private final HTMLAnchorElement insertFieldBelow;
    @DataField(value="insert-nested-field")
    private final HTMLAnchorElement insertNestedField;
    @DataField(value="kebab-menu")
    private HTMLDivElement kebabMenu;
    private DataTypeListItem presenter;

    @Inject
    public DataTypeListItemView(HTMLDivElement view, @Named(value="span") HTMLElement level, @Named(value="span") HTMLElement arrow, @Named(value="span") HTMLElement nameText, HTMLInputElement nameInput, @Named(value="span") HTMLElement type, HTMLButtonElement editButton, HTMLButtonElement saveButton, HTMLButtonElement closeButton, HTMLAnchorElement removeButton, HTMLAnchorElement insertFieldAbove, HTMLAnchorElement insertFieldBelow, HTMLAnchorElement insertNestedField, HTMLDivElement kebabMenu) {
        this.view = view;
        this.level = level;
        this.arrow = arrow;
        this.nameText = nameText;
        this.nameInput = nameInput;
        this.type = type;
        this.editButton = editButton;
        this.saveButton = saveButton;
        this.closeButton = closeButton;
        this.removeButton = removeButton;
        this.insertFieldAbove = insertFieldAbove;
        this.insertFieldBelow = insertFieldBelow;
        this.insertNestedField = insertNestedField;
        this.kebabMenu = kebabMenu;
    }

    @PostConstruct
    public void setupKebabElement() {
        new KebabMenuInitializer(this.kebabMenu).init();
    }

    public void init(DataTypeListItem presenter) {
        this.presenter = presenter;
    }

    public HTMLElement getElement() {
        return this.view;
    }

    void setupRowMetadata(DataType dataType) {
        this.getElement().setAttribute(UUID_ATTR, dataType.getUUID());
        this.getElement().setAttribute(PARENT_UUID_ATTR, dataType.getParentUUID());
    }

    void setupArrow(DataType dataType) {
        this.toggleArrow(dataType.hasSubDataTypes());
    }

    void setupIndentationLevel() {
        int indentationLevel = this.presenter.getLevel();
        int marginPixels = 35 * indentationLevel;
        this.level.style.marginLeft = this.margin(marginPixels);
    }

    void setupNameComponent(DataType dataType) {
        HiddenHelper.hide((Element)this.nameInput);
        this.setName(dataType.getName());
    }

    void setupActionButtons() {
        this.showEditButton();
    }

    @Override
    public void toggleArrow(boolean show) {
        if (show) {
            HiddenHelper.show((Element)this.arrow);
        } else {
            HiddenHelper.hide((Element)this.arrow);
        }
    }

    @Override
    public void expand() {
        Element parent = this.getRowElement(this.getDataType());
        ListItemViewCssHelper.asDownArrow((Element)this.getArrow());
        this.forEachChildElement(parent, (Element child) -> {
            HiddenHelper.show(child);
            return !this.isCollapsed(child.querySelector(ARROW_BUTTON_SELECTOR));
        });
    }

    @Override
    public void collapse() {
        Element parent = this.getRowElement(this.getDataType());
        ListItemViewCssHelper.asRightArrow((Element)this.getArrow());
        this.forEachChildElement(parent, HiddenHelper::hide);
    }

    @Override
    public void showEditButton() {
        HiddenHelper.show((Element)this.editButton);
        HiddenHelper.hide((Element)this.saveButton);
        HiddenHelper.hide((Element)this.closeButton);
    }

    @Override
    public void showSaveButton() {
        HiddenHelper.hide((Element)this.editButton);
        HiddenHelper.show((Element)this.saveButton);
        HiddenHelper.show((Element)this.closeButton);
    }

    @EventHandler(value={"edit-button"})
    public void onEditClick(ClickEvent e) {
        this.presenter.enableEditMode();
    }

    @EventHandler(value={"save-button"})
    public void onSaveClick(ClickEvent e) {
        this.presenter.saveAndCloseEditMode();
    }

    @EventHandler(value={"close-button"})
    public void onCloseClick(ClickEvent e) {
        this.presenter.disableEditMode();
    }

    @EventHandler(value={"arrow-button"})
    public void onArrowClickEvent(ClickEvent e) {
        this.presenter.expandOrCollapseSubTypes();
    }

    @EventHandler(value={"insert-field-above"})
    public void onInsertFieldAbove(ClickEvent e) {
        this.presenter.insertFieldAbove();
    }

    @EventHandler(value={"insert-field-below"})
    public void onInsertFieldBelow(ClickEvent e) {
        this.presenter.insertFieldBelow();
    }

    @EventHandler(value={"insert-nested-field"})
    public void onInsertNestedField(ClickEvent e) {
        this.presenter.insertNestedField();
    }

    @EventHandler(value={"remove-button"})
    public void onRemoveButton(ClickEvent e) {
        this.presenter.remove();
    }

    @Override
    public void enableFocusMode() {
        Element rowElement = this.getRowElement(this.getDataType());
        ListItemViewCssHelper.asFocusedDataType(rowElement);
        this.forEachChildElement(rowElement, ListItemViewCssHelper::asFocusedDataType);
        this.nameInput.select();
    }

    @Override
    public void disableFocusMode() {
        Element rowElement = this.getRowElement(this.getDataType());
        if (rowElement != null) {
            ListItemViewCssHelper.asNonFocusedDataType(rowElement);
            this.forEachChildElement(rowElement, ListItemViewCssHelper::asNonFocusedDataType);
        }
    }

    @Override
    public String getName() {
        return this.nameInput.value;
    }

    @Override
    public void setName(String name) {
        this.nameText.textContent = name;
        this.nameInput.value = name;
    }

    @Override
    public void showDataTypeNameInput() {
        HiddenHelper.hide((Element)this.nameText);
        HiddenHelper.show((Element)this.nameInput);
    }

    @Override
    public void hideDataTypeNameInput() {
        this.nameText.textContent = this.nameInput.value.isEmpty() ? "-" : this.nameInput.value;
        HiddenHelper.hide((Element)this.nameInput);
        HiddenHelper.show((Element)this.nameText);
    }

    @Override
    public void setupSelectComponent(DataTypeSelect typeSelect) {
        this.type.innerHTML = "";
        this.type.appendChild((Node)typeSelect.getElement());
    }

    @Override
    public boolean isCollapsed() {
        return this.isCollapsed((Element)this.getArrow());
    }

    HTMLElement getArrow() {
        return this.arrow;
    }

    Element getRowElement(DataType dataType) {
        return this.getRowElement(dataType.getUUID());
    }

    CSSProperties.MarginLeftUnionType margin(int pixels) {
        return CSSProperties.MarginLeftUnionType.of((Object)(pixels + "px"));
    }

    boolean isCollapsed(Element arrow) {
        return ListItemViewCssHelper.isRightArrow(arrow);
    }

    private void forEachChildElement(Element parent, Consumer<Element> consumer) {
        this.forEachChildElement(parent, (Element element) -> {
            consumer.accept((Element)element);
            return true;
        });
    }

    private void forEachChildElement(Element parent, Function<Element, Boolean> consumer) {
        NodeList<Element> children = this.getChildren(parent);
        int i = 0;
        while ((double)i < children.length) {
            Element child = (Element)children.getAt(i);
            if (consumer.apply(child).booleanValue()) {
                this.forEachChildElement(child, consumer);
            }
            ++i;
        }
    }

    private Element getRowElement(String uuid) {
        return this.dataTypeListElement().querySelector("[data-row-uuid=\"" + uuid + "\"]");
    }

    private NodeList<Element> getChildren(Element parent) {
        String childrenSelector = "[data-parent-row-uuid=\"" + parent.getAttribute(UUID_ATTR) + "\"]";
        return this.dataTypeListElement().querySelectorAll(childrenSelector);
    }

    HTMLElement dataTypeListElement() {
        return this.presenter.getDataTypeList().getElement();
    }

    DataType getDataType() {
        return this.presenter.getDataType();
    }

    @Override
    public void setDataType(DataType dataType) {
        this.setupRowMetadata(dataType);
        this.setupArrow(dataType);
        this.setupIndentationLevel();
        this.setupNameComponent(dataType);
        this.setupActionButtons();
    }
}

