/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.common;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONNumber;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import elemental2.dom.DomGlobal;
import elemental2.dom.Element;
import elemental2.dom.HTMLDivElement;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.JQuery;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.JQueryEvent;

public class KebabMenuInitializer {
    private final HTMLDivElement kebabMenu;

    public KebabMenuInitializer(HTMLDivElement kebabMenu) {
        this.kebabMenu = kebabMenu;
    }

    public void init() {
        Element dropdown = this.dropdown();
        JQuery.$(dropdown).on("show.bs.dropdown", this.moveDropDownToBody());
        JQuery.$(dropdown).on("hidden.bs.dropdown", this.moveDropDownToKebabContainer());
    }

    JQuery.CallbackFunction moveDropDownToBody() {
        return event -> {
            JavaScriptObject properties = this.bodyDropdownProperties(event).getJavaScriptObject();
            JQuery $ = JQuery.$(this.modalInElement());
            JQuery css = JQuery.$(event.target).css(properties);
            JQuery detach = css.detach();
            $.append(detach);
        };
    }

    JQuery.CallbackFunction moveDropDownToKebabContainer() {
        return event -> {
            JavaScriptObject properties = this.emptyProperties().getJavaScriptObject();
            JQuery.$((Element)this.kebabMenu).append(JQuery.$(event.target).css(properties).detach());
        };
    }

    JSONObject bodyDropdownProperties(JQueryEvent e) {
        JSONObject jsonObject = this.makeJsonObject();
        jsonObject.put("position", (JSONValue)new JSONString("absolute"));
        jsonObject.put("zIndex", (JSONValue)new JSONNumber(1051.0));
        jsonObject.put("left", (JSONValue)new JSONNumber(this.offsetLeft(e.target)));
        jsonObject.put("top", (JSONValue)new JSONNumber(this.offsetTop(e.target)));
        return jsonObject;
    }

    JSONObject emptyProperties() {
        JSONObject jsonObject = this.makeJsonObject();
        jsonObject.put("position", (JSONValue)new JSONString(""));
        jsonObject.put("zIndex", (JSONValue)new JSONString(""));
        jsonObject.put("left", (JSONValue)new JSONString(""));
        jsonObject.put("top", (JSONValue)new JSONString(""));
        return jsonObject;
    }

    JSONObject makeJsonObject() {
        return new JSONObject();
    }

    Element modalInElement() {
        return DomGlobal.document.querySelector(".modal.in");
    }

    Element dropdown() {
        return this.kebabMenu.querySelector(".dropdown");
    }

    double offsetLeft(Element target) {
        return target.getBoundingClientRect().left + this.modalInElement().scrollLeft;
    }

    double offsetTop(Element target) {
        return target.getBoundingClientRect().top + this.modalInElement().scrollTop;
    }
}

