/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.messages;

import elemental2.dom.HTMLElement;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.kie.workbench.common.dmn.client.editors.types.messages.DataTypeFlashMessage;
import org.uberfire.client.mvp.UberElemental;

@ApplicationScoped
public class DataTypeFlashMessages {
    private final View view;

    @Inject
    public DataTypeFlashMessages(View view) {
        this.view = view;
    }

    @PostConstruct
    void setup() {
        this.view.init(this);
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    public void onNameIsBlankErrorMessage(@Observes DataTypeFlashMessage flashMessage) {
        this.showFlashMessage(flashMessage);
        this.highlightDataField(flashMessage);
    }

    void showFlashMessage(DataTypeFlashMessage flashMessage) {
        switch (flashMessage.getType()) {
            case ERROR: {
                this.view.showErrorMessage(flashMessage.getStrongMessage(), flashMessage.getRegularMessage());
                break;
            }
            case WARNING: {
                this.view.showWarningMessage(flashMessage.getStrongMessage(), flashMessage.getRegularMessage());
            }
        }
    }

    void highlightDataField(DataTypeFlashMessage flashMessage) {
        switch (flashMessage.getType()) {
            case ERROR: {
                this.view.showErrorHighlight(flashMessage.getErrorElementSelector());
                break;
            }
            case WARNING: {
                this.view.showWarningHighlight(flashMessage.getErrorElementSelector());
            }
        }
    }

    public static interface View
    extends UberElemental<DataTypeFlashMessages>,
    IsElement {
        public void showErrorMessage(String var1, String var2);

        public void showWarningMessage(String var1, String var2);

        public void showErrorHighlight(String var1);

        public void showWarningHighlight(String var1);
    }
}

