/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.messages;

import elemental2.dom.DomGlobal;
import elemental2.dom.Element;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.client.editors.types.messages.DataTypeFlashMessages;

@Templated
@ApplicationScoped
public class DataTypeFlashMessagesView
implements DataTypeFlashMessages.View {
    static final String ERROR_CSS_CLASS = "kie-data-types-error-element";
    static final String OPENED_CONTAINER_CSS_CLASS = "opened";
    @DataField(value="error-container")
    private final HTMLDivElement errorContainer;
    @DataField(value="warning-container")
    private final HTMLDivElement warningContainer;
    @DataField(value="strong-error-message")
    private final HTMLElement strongErrorMessage;
    @DataField(value="regular-error-message")
    private final HTMLElement regularErrorMessage;
    @DataField(value="strong-warning-message")
    private final HTMLElement strongWarningMessage;
    @DataField(value="regular-warning-message")
    private final HTMLElement regularWarningMessage;
    private DataTypeFlashMessages presenter;

    @Inject
    public DataTypeFlashMessagesView(HTMLDivElement errorContainer, HTMLDivElement warningContainer, @Named(value="strong") HTMLElement strongErrorMessage, @Named(value="span") HTMLElement regularErrorMessage, @Named(value="strong") HTMLElement strongWarningMessage, @Named(value="span") HTMLElement regularWarningMessage) {
        this.errorContainer = errorContainer;
        this.warningContainer = warningContainer;
        this.strongErrorMessage = strongErrorMessage;
        this.regularErrorMessage = regularErrorMessage;
        this.strongWarningMessage = strongWarningMessage;
        this.regularWarningMessage = regularWarningMessage;
    }

    public void init(DataTypeFlashMessages presenter) {
        this.presenter = presenter;
    }

    @Override
    public void showErrorMessage(String strongMessage, String regularMessage) {
        this.show((Element)this.errorContainer);
        this.strongErrorMessage.textContent = strongMessage;
        this.regularErrorMessage.textContent = regularMessage;
    }

    @Override
    public void showErrorHighlight(String errorElementSelector) {
        Element element = this.getElement().parentNode.querySelector(errorElementSelector);
        this.enableErrorHighlight(element);
        this.setupDisableErrorHighlightCallbacks(element);
        element.focus();
    }

    @Override
    public void showWarningMessage(String strongMessage, String regularMessage) {
    }

    @Override
    public void showWarningHighlight(String errorElementSelector) {
    }

    void setupDisableErrorHighlightCallbacks(Element element) {
        element.onkeypress = e -> {
            this.disableErrorHighlight(element);
            return true;
        };
        element.onblur = e -> {
            this.disableErrorHighlight(element);
            return true;
        };
    }

    void enableErrorHighlight(Element element) {
        element.classList.add(new String[]{ERROR_CSS_CLASS});
    }

    void disableErrorHighlight(Element element) {
        element.classList.remove(new String[]{ERROR_CSS_CLASS});
        this.setTimeout(type -> {
            boolean isErrorEnabled = element.classList.contains(ERROR_CSS_CLASS);
            if (!isErrorEnabled) {
                this.hide((Element)this.errorContainer);
                this.teardownDisableErrorHighlightCallbacks(element);
            }
        }, 500.0);
    }

    void teardownDisableErrorHighlightCallbacks(Element element) {
        element.onkeypress = e -> true;
        element.onblur = e -> true;
    }

    void setTimeout(DomGlobal.SetTimeoutCallbackFn callback, double delay) {
        DomGlobal.setTimeout((DomGlobal.SetTimeoutCallbackFn)callback, (double)delay, (Object[])new Object[0]);
    }

    private void hide(Element element) {
        element.classList.remove(new String[]{OPENED_CONTAINER_CSS_CLASS});
    }

    private void show(Element element) {
        element.classList.add(new String[]{OPENED_CONTAINER_CSS_CLASS});
    }
}

