/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.persistence.common;

import java.util.List;
import java.util.Optional;
import org.kie.workbench.common.dmn.client.editors.types.persistence.common.RecordEngine;

public abstract class ActiveRecord<T> {
    private RecordEngine<T> recordEngine;

    public ActiveRecord(RecordEngine<T> recordEngine) {
        this.recordEngine = recordEngine;
    }

    public List<T> update() {
        return this.getRecordEngine().update(this.getRecord());
    }

    public List<T> destroy() {
        return this.getRecordEngine().destroy(this.getRecord());
    }

    public List<T> create() {
        return this.getRecordEngine().create(this.getRecord());
    }

    public boolean isValid() {
        return this.getRecordEngine().isValid(this.getRecord());
    }

    public RecordEngine<T> getRecordEngine() {
        return Optional.ofNullable(this.recordEngine).orElseThrow(this::error);
    }

    protected abstract T getRecord();

    private UnsupportedOperationException error() {
        String errorMessage = "'ActiveRecord' operations are not supported. Please provide a record engine.";
        return new UnsupportedOperationException("'ActiveRecord' operations are not supported. Please provide a record engine.");
    }
}

