/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.persistence.handlers;

import java.util.Objects;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.editors.types.common.BuiltInTypeUtils;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManager;
import org.kie.workbench.common.dmn.client.editors.types.common.ItemDefinitionUtils;

@Dependent
public class ItemDefinitionUpdateHandler {
    private final DataTypeManager dataTypeManager;
    private final ItemDefinitionUtils itemDefinitionUtils;

    @Inject
    public ItemDefinitionUpdateHandler(DataTypeManager dataTypeManager, ItemDefinitionUtils itemDefinitionUtils) {
        this.dataTypeManager = dataTypeManager;
        this.itemDefinitionUtils = itemDefinitionUtils;
    }

    public void update(DataType dataType, ItemDefinition itemDefinition) {
        if (this.isStructure(dataType)) {
            itemDefinition.setTypeRef(null);
        } else {
            itemDefinition.setTypeRef(this.makeQName(dataType));
            itemDefinition.getItemComponent().clear();
        }
        itemDefinition.setName(this.makeName(dataType));
    }

    Name makeName(DataType dataType) {
        return new Name(dataType.getName());
    }

    QName makeQName(DataType dataType) {
        if (BuiltInTypeUtils.isDefault(dataType.getType())) {
            return this.normaliseTypeRef(new QName(DMNModelInstrumentedBase.Namespace.FEEL.getUri(), dataType.getType()));
        }
        return this.normaliseTypeRef(new QName("", dataType.getType()));
    }

    QName normaliseTypeRef(QName typeRef) {
        return this.itemDefinitionUtils.normaliseTypeRef(typeRef);
    }

    private boolean isStructure(DataType dataType) {
        return Objects.equals(dataType.getType(), this.dataTypeManager.structure());
    }
}

