/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.layer;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPathClipper;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.core.shape.Rectangle;
import com.ait.lienzo.client.core.types.Transform;
import com.ait.lienzo.shared.core.types.ColorName;
import com.ait.lienzo.shared.core.types.IColor;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Command;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionContainerGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.literal.LiteralExpressionGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.UndefinedExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.dnd.DelegatingGridWidgetDndMouseMoveHandler;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.layer.InverseGridWidgetClipper;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.widget.dnd.GridWidgetDnDMouseMoveHandler;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.DefaultGridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLayerRedrawManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.TransformMediator;

public class DMNGridLayer
extends DefaultGridLayer {
    private TransformMediator defaultTransformMediator;
    private Optional<GridWidget> selectedGridWidget = Optional.empty();

    public void setDefaultTransformMediator(TransformMediator defaultTransformMediator) {
        this.defaultTransformMediator = defaultTransformMediator;
    }

    public Layer draw() {
        return this.batch();
    }

    public Layer batch() {
        return this.batch(new GridLayerRedrawManager.PrioritizedCommand(Integer.MIN_VALUE){

            public void execute() {
                DMNGridLayer.this.doBatch();
            }
        });
    }

    Layer doBatch() {
        Layer layer = super.draw();
        this.findExpressionContainer().ifPresent(container -> this.selectedGridWidget.ifPresent(gridWidget -> this.addGhost((ExpressionContainerGrid)container, (GridWidget)gridWidget)));
        return layer;
    }

    Optional<ExpressionContainerGrid> findExpressionContainer() {
        return this.getGridWidgets().stream().filter(gw -> gw instanceof ExpressionContainerGrid).map(gw -> (ExpressionContainerGrid)gw).findFirst();
    }

    void addGhost(ExpressionContainerGrid container, GridWidget gridWidget) {
        Rectangle r = this.getGhostRectangle();
        r.setWidth(container.getWidth() + 1.0);
        r.setHeight(container.getHeight() + 1.0);
        r.setFillColor((IColor)ColorName.WHITE);
        r.setAlpha(0.5);
        r.setListening(false);
        Group g = (Group)GWT.create(Group.class);
        Transform transform = this.getViewport().getTransform();
        g.setX(container.getX() + transform.getTranslateX());
        g.setY(container.getY() + transform.getTranslateY());
        g.add((IPrimitive)r);
        GridWidget gw = gridWidget;
        if (gw instanceof LiteralExpressionGrid) {
            gw = ((LiteralExpressionGrid)gw).getParentInformation().getGridWidget();
        } else if (gw instanceof UndefinedExpressionGrid) {
            gw = ((UndefinedExpressionGrid)gw).getParentInformation().getGridWidget();
        }
        InverseGridWidgetClipper clipper = new InverseGridWidgetClipper((GridWidget)container, gw);
        clipper.setActive(true);
        g.setPathClipper((IPathClipper)clipper);
        g.drawWithTransforms(this.getContext(), 1.0, this.getStorageBounds());
    }

    Rectangle getGhostRectangle() {
        return new Rectangle(0.0, 0.0);
    }

    Optional<GridWidget> getSelectedGridWidget() {
        return this.selectedGridWidget;
    }

    public TransformMediator getDefaultTransformMediator() {
        return this.defaultTransformMediator;
    }

    public void exitPinnedMode(Command onCompleteCommand) {
    }

    public void updatePinnedContext(GridWidget gridWidget) throws IllegalStateException {
    }

    public void select(GridWidget selectedGridWidget) {
        this.selectedGridWidget = Optional.of(selectedGridWidget);
        boolean selectionChanged = false;
        for (GridWidget gridWidget : this.getAllGridWidgets()) {
            if (gridWidget.isSelected() && !Objects.equals(gridWidget, selectedGridWidget)) {
                selectionChanged = true;
                gridWidget.deselect();
                continue;
            }
            if (gridWidget.isSelected() || !Objects.equals(gridWidget, selectedGridWidget)) continue;
            selectionChanged = true;
            gridWidget.select();
        }
        if (selectionChanged) {
            this.batch();
        }
    }

    private Set<GridWidget> getAllGridWidgets() {
        Set gridWidgets = super.getGridWidgets();
        HashSet<GridWidget> allGridWidgets = new HashSet<GridWidget>();
        gridWidgets.forEach(grid -> allGridWidgets.addAll(this.collectGridWidgets((GridWidget)grid)));
        return allGridWidgets;
    }

    private Set<GridWidget> collectGridWidgets(GridWidget gridWidget) {
        HashSet<GridWidget> allGridWidgets = new HashSet<GridWidget>();
        allGridWidgets.add(gridWidget);
        gridWidget.getModel().getRows().stream().forEach(row -> row.getCells().values().stream().filter(cell -> cell != null && cell.getValue() != null).map(GridCell::getValue).filter(value -> value instanceof ExpressionCellValue).map(value -> (ExpressionCellValue)((Object)((Object)value))).filter(value -> ((Optional)value.getValue()).isPresent()).map(value -> (BaseExpressionGrid)((Optional)value.getValue()).get()).forEach(editor -> allGridWidgets.addAll(this.collectGridWidgets((GridWidget)editor))));
        return allGridWidgets;
    }

    public void deregister(GridWidget gridWidget) {
        if (this.selectedGridWidget.isPresent() && this.selectedGridWidget.get().equals(gridWidget)) {
            this.selectedGridWidget = Optional.empty();
        }
        super.deregister(gridWidget);
    }

    public Layer removeAll() {
        this.selectedGridWidget = Optional.empty();
        return super.removeAll();
    }

    protected GridWidgetDnDMouseMoveHandler getGridWidgetDnDMouseMoveHandler() {
        return new DelegatingGridWidgetDndMouseMoveHandler((GridLayer)this, this.getGridWidgetHandlersState());
    }
}

