/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.panel;

import java.util.stream.Stream;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanelCellSelectionHandler;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.CellSelectionStrategy;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.impl.RangeSelectionStrategy;

public class DMNGridPanelCellSelectionHandlerImpl
implements DMNGridPanelCellSelectionHandler {
    private final DMNGridLayer gridLayer;

    public DMNGridPanelCellSelectionHandlerImpl(DMNGridLayer gridLayer) {
        this.gridLayer = gridLayer;
    }

    @Override
    public void selectCellIfRequired(int uiRowIndex, int uiColumnIndex, GridWidget gridWidget, boolean isShiftKeyDown, boolean isControlKeyDown) {
        GridData gridData = gridWidget.getModel();
        GridColumn column = (GridColumn)gridData.getColumns().get(uiColumnIndex);
        Stream<GridData.SelectedCell> modelColumnSelectedCells = gridData.getSelectedCells().stream().filter(sc -> sc.getColumnIndex() == column.getIndex());
        boolean isContextMenuCellSelectedCell = modelColumnSelectedCells.map(GridData.SelectedCell::getRowIndex).anyMatch(ri -> ri == uiRowIndex);
        if (!isContextMenuCellSelectedCell) {
            this.selectCell(uiRowIndex, uiColumnIndex, gridWidget, isShiftKeyDown, isControlKeyDown);
        }
    }

    private void selectCell(int uiRowIndex, int uiColumnIndex, GridWidget gridWidget, boolean isShiftKeyDown, boolean isControlKeyDown) {
        GridData gridModel = gridWidget.getModel();
        GridCell cell = gridModel.getCell(uiRowIndex, uiColumnIndex);
        CellSelectionStrategy selectionStrategy = cell == null ? RangeSelectionStrategy.INSTANCE : cell.getSelectionStrategy();
        if (selectionStrategy == null) {
            return;
        }
        this.gridLayer.select(gridWidget);
        if (selectionStrategy.handleSelection(gridModel, uiRowIndex, uiColumnIndex, isShiftKeyDown, isControlKeyDown)) {
            this.gridLayer.batch();
        }
    }
}

