/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.panel;

import com.ait.lienzo.client.core.types.Point2D;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.ContextMenuEvent;
import com.google.gwt.event.dom.client.ContextMenuHandler;
import java.util.ArrayList;
import java.util.Optional;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.HasCellEditorControls;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanelCellSelectionHandler;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.util.CoordinateUtilities;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;

public class DMNGridPanelContextMenuHandler
implements ContextMenuHandler {
    static final Optional<String> EDITOR_TITLE = Optional.empty();
    private DMNGridLayer gridLayer;
    private CellEditorControlsView.Presenter cellEditorControls;
    private DMNGridPanelCellSelectionHandler cellSelectionHandler;

    public DMNGridPanelContextMenuHandler(DMNGridLayer gridLayer, CellEditorControlsView.Presenter cellEditorControls, DMNGridPanelCellSelectionHandler cellSelectionHandler) {
        this.gridLayer = gridLayer;
        this.cellEditorControls = cellEditorControls;
        this.cellSelectionHandler = cellSelectionHandler;
    }

    public void onContextMenu(ContextMenuEvent event) {
        event.preventDefault();
        event.stopPropagation();
        int canvasX = this.getRelativeX(event);
        int canvasY = this.getRelativeY(event);
        boolean isShiftKeyDown = event.getNativeEvent().getShiftKey();
        boolean isControlKeyDown = event.getNativeEvent().getCtrlKey();
        ArrayList<CandidateGridWidget> candidateGridWidgets = new ArrayList<CandidateGridWidget>();
        for (GridWidget gridWidget : this.gridLayer.getGridWidgets()) {
            GridCell cell;
            GridData gridModel = gridWidget.getModel();
            Point2D ap = CoordinateUtilities.convertDOMToGridCoordinate((GridWidget)gridWidget, (Point2D)new Point2D((double)canvasX, (double)canvasY));
            Integer uiRowIndex = CoordinateUtilities.getUiRowIndex((GridWidget)gridWidget, (double)ap.getY());
            Integer uiColumnIndex = CoordinateUtilities.getUiColumnIndex((GridWidget)gridWidget, (double)ap.getX());
            if (uiRowIndex == null || uiColumnIndex == null || (cell = gridModel.getCell(uiRowIndex.intValue(), uiColumnIndex.intValue())) == null || !(cell instanceof HasCellEditorControls)) continue;
            HasCellEditorControls hasControls = (HasCellEditorControls)cell;
            candidateGridWidgets.add(new CandidateGridWidget(ap, uiRowIndex, uiColumnIndex, gridWidget, hasControls));
        }
        if (candidateGridWidgets.isEmpty()) {
            return;
        }
        CandidateGridWidget candidateGridWidget = (CandidateGridWidget)candidateGridWidgets.get(candidateGridWidgets.size() - 1);
        Point2D ap = candidateGridWidget.ap;
        int uiRowIndex = candidateGridWidget.uiRowIndex;
        int uiColumnIndex = candidateGridWidget.uiColumnIndex;
        GridWidget gridWidget = candidateGridWidget.gridWidget;
        HasCellEditorControls hasCellEditorControls = candidateGridWidget.hasCellEditorControls;
        Optional<HasCellEditorControls.Editor> editor = hasCellEditorControls.getEditor();
        this.cellSelectionHandler.selectCellIfRequired(uiRowIndex, uiColumnIndex, gridWidget, isShiftKeyDown, isControlKeyDown);
        editor.ifPresent(e -> {
            e.bind(gridWidget, uiRowIndex, uiColumnIndex);
            this.cellEditorControls.show((HasCellEditorControls.Editor<?>)e, EDITOR_TITLE, (int)(ap.getX() + gridWidget.getAbsoluteX()), (int)(ap.getY() + gridWidget.getAbsoluteY()));
        });
    }

    private int getRelativeX(ContextMenuEvent event) {
        NativeEvent e = event.getNativeEvent();
        Element target = event.getRelativeElement();
        return e.getClientX() - target.getAbsoluteLeft() + target.getScrollLeft() + target.getOwnerDocument().getScrollLeft();
    }

    private int getRelativeY(ContextMenuEvent event) {
        NativeEvent e = event.getNativeEvent();
        Element target = event.getRelativeElement();
        return e.getClientY() - target.getAbsoluteTop() + target.getScrollTop() + target.getOwnerDocument().getScrollTop();
    }

    private class CandidateGridWidget {
        final Point2D ap;
        final int uiRowIndex;
        final int uiColumnIndex;
        final GridWidget gridWidget;
        final HasCellEditorControls hasCellEditorControls;

        public CandidateGridWidget(Point2D ap, int uiRowIndex, int uiColumnIndex, GridWidget gridWidget, HasCellEditorControls hasCellEditorControls) {
            this.ap = ap;
            this.uiRowIndex = uiRowIndex;
            this.uiColumnIndex = uiColumnIndex;
            this.gridWidget = gridWidget;
            this.hasCellEditorControls = hasCellEditorControls;
        }
    }
}

