/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.canvas.controls.selection;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.dmn.api.qualifiers.DMNEditor;
import org.kie.workbench.common.stunner.client.lienzo.canvas.controls.LienzoMultipleSelectionControl;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.select.MultipleSelection;
import org.kie.workbench.common.stunner.core.client.canvas.controls.select.SelectionControl;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasClearSelectionEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasSelectionEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.domainobject.DomainObject;
import org.kie.workbench.common.stunner.core.graph.Element;

@Dependent
@MultipleSelection
@DMNEditor
public class DomainObjectAwareLienzoMultipleSelectionControl<H extends AbstractCanvasHandler>
extends LienzoMultipleSelectionControl<H> {
    private Optional<DomainObject> selectedDomainObject = Optional.empty();

    @Inject
    public DomainObjectAwareLienzoMultipleSelectionControl(Event<CanvasSelectionEvent> canvasSelectionEvent, Event<CanvasClearSelectionEvent> clearSelectionEvent) {
        super(canvasSelectionEvent, clearSelectionEvent);
    }

    public Optional<Object> getSelectedItemDefinition() {
        if (this.selectedDomainObject.isPresent()) {
            return Optional.of(this.selectedDomainObject.get());
        }
        return super.getSelectedItemDefinition();
    }

    protected void onSelect(Collection<String> uuids) {
        this.selectedDomainObject = Optional.empty();
        super.onSelect(uuids);
    }

    public SelectionControl<H, Element> select(String uuid) {
        this.selectedDomainObject = Optional.empty();
        return super.select(uuid);
    }

    public void clear() {
        this.selectedDomainObject = Optional.empty();
        super.clear();
    }

    protected void onClearSelection() {
        this.selectedDomainObject = Optional.empty();
        super.onClearSelection();
    }

    public void destroy() {
        this.selectedDomainObject = Optional.empty();
        super.destroy();
    }

    protected void onDestroy() {
        this.selectedDomainObject = Optional.empty();
        super.onDestroy();
    }

    protected void handleCanvasElementSelectedEvent(CanvasSelectionEvent event) {
        this.selectedDomainObject = Optional.empty();
        super.handleCanvasElementSelectedEvent(event);
    }

    protected void handleCanvasClearSelectionEvent(CanvasClearSelectionEvent event) {
        this.selectedDomainObject = Optional.empty();
        super.handleCanvasClearSelectionEvent(event);
    }

    void handleDomainObjectSelectedEvent(@Observes DomainObjectSelectionEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        if (Objects.equals(this.getCanvasHandler(), event.getCanvasHandler())) {
            this.selectedDomainObject = Optional.ofNullable(event.getDomainObject());
        }
    }

    private AbstractCanvasHandler getCanvasHandler() {
        return this.getSelectionControl().getCanvasHandler();
    }
}

