/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.function.supplementary;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.kie.workbench.common.dmn.api.definition.v1_1.Context;
import org.kie.workbench.common.dmn.api.definition.v1_1.ContextEntry;
import org.kie.workbench.common.dmn.client.commands.VetoExecutionCommand;
import org.kie.workbench.common.dmn.client.commands.VetoUndoCommand;
import org.kie.workbench.common.dmn.client.commands.util.CommandUtils;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.mvp.Command;

public class MoveRowsCommand
extends AbstractCanvasGraphCommand
implements VetoExecutionCommand,
VetoUndoCommand {
    private final Context context;
    private final DMNGridData uiModel;
    private final int index;
    private final List<GridRow> rows;
    private final Command canvasOperation;
    private final int oldIndex;

    public MoveRowsCommand(Context context, DMNGridData uiModel, int index, List<GridRow> rows, Command canvasOperation) {
        this.context = context;
        this.uiModel = uiModel;
        this.index = index;
        this.rows = new ArrayList<GridRow>(rows);
        this.canvasOperation = canvasOperation;
        this.oldIndex = uiModel.getRows().indexOf(rows.get(0));
    }

    protected org.kie.workbench.common.stunner.core.command.Command<GraphCommandExecutionContext, RuleViolation> newGraphCommand(AbstractCanvasHandler ach) {
        return new AbstractGraphCommand(){

            protected CommandResult<RuleViolation> check(GraphCommandExecutionContext gcec) {
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> execute(GraphCommandExecutionContext gcec) {
                this.moveRows(MoveRowsCommand.this.index);
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> undo(GraphCommandExecutionContext gcec) {
                this.moveRows(MoveRowsCommand.this.oldIndex);
                return GraphCommandResultBuilder.SUCCESS;
            }

            private void moveRows(int index) {
                List rowsToMove = MoveRowsCommand.this.rows.stream().map(r -> MoveRowsCommand.this.uiModel.getRows().indexOf(r)).map(i -> (ContextEntry)MoveRowsCommand.this.context.getContextEntry().get((int)i)).collect(Collectors.toList());
                List rows = MoveRowsCommand.this.context.getContextEntry();
                CommandUtils.moveRows(rows, rowsToMove, index);
            }
        };
    }

    protected org.kie.workbench.common.stunner.core.command.Command<AbstractCanvasHandler, CanvasViolation> newCanvasCommand(AbstractCanvasHandler ach) {
        return new AbstractCanvasCommand(){

            public CommandResult<CanvasViolation> allow(AbstractCanvasHandler context) {
                if (MoveRowsCommand.this.index == MoveRowsCommand.this.uiModel.getRowCount() - 1) {
                    return CanvasCommandResultBuilder.FAILED;
                }
                return CanvasCommandResultBuilder.SUCCESS;
            }

            public CommandResult<CanvasViolation> execute(AbstractCanvasHandler ach) {
                MoveRowsCommand.this.uiModel.moveRowsTo(MoveRowsCommand.this.index, MoveRowsCommand.this.rows);
                MoveRowsCommand.this.updateRowNumbers();
                MoveRowsCommand.this.updateParentInformation();
                MoveRowsCommand.this.canvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }

            public CommandResult<CanvasViolation> undo(AbstractCanvasHandler ach) {
                MoveRowsCommand.this.uiModel.moveRowsTo(MoveRowsCommand.this.oldIndex, MoveRowsCommand.this.rows);
                MoveRowsCommand.this.updateRowNumbers();
                MoveRowsCommand.this.updateParentInformation();
                MoveRowsCommand.this.canvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }
        };
    }

    public void updateRowNumbers() {
        CommandUtils.updateRowNumbers((GridData)this.uiModel, IntStream.range(0, this.uiModel.getRowCount()));
    }

    public void updateParentInformation() {
        CommandUtils.updateParentInformation((GridData)this.uiModel);
    }
}

