/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.decision;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.dmn.client.decision.DecisionNavigatorPresenter;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.client.workbench.docks.UberfireDocks;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@ApplicationScoped
public class DecisionNavigatorDock {
    static final double DOCK_SIZE = 400.0;
    private UberfireDocks uberfireDocks;
    private DecisionNavigatorPresenter decisionNavigatorPresenter;
    private TranslationService translationService;
    private UberfireDock uberfireDock;
    private boolean isOpened = false;
    private String perspective;

    public DecisionNavigatorDock() {
    }

    @Inject
    public DecisionNavigatorDock(UberfireDocks uberfireDocks, DecisionNavigatorPresenter decisionNavigatorPresenter, TranslationService translationService) {
        this.uberfireDocks = uberfireDocks;
        this.decisionNavigatorPresenter = decisionNavigatorPresenter;
        this.translationService = translationService;
    }

    public void init(String perspective) {
        this.perspective = perspective;
        this.uberfireDock = this.makeUberfireDock();
    }

    public void setupContent(CanvasHandler handler) {
        this.decisionNavigatorPresenter.setHandler(handler);
    }

    public void resetContent() {
        this.decisionNavigatorPresenter.removeAllElements();
    }

    public void open() {
        if (this.isOpened()) {
            return;
        }
        this.isOpened = true;
        this.uberfireDocks.add(new UberfireDock[]{this.getUberfireDock()});
        this.uberfireDocks.show(this.position(), this.perspective());
        this.uberfireDocks.open(this.getUberfireDock());
    }

    public void close() {
        if (!this.isOpened()) {
            return;
        }
        this.isOpened = false;
        this.uberfireDocks.close(this.getUberfireDock());
        this.uberfireDocks.remove(new UberfireDock[]{this.getUberfireDock()});
    }

    boolean isOpened() {
        return this.isOpened;
    }

    void setOpened(boolean opened) {
        this.isOpened = opened;
    }

    UberfireDock makeUberfireDock() {
        UberfireDock uberfireDock = new UberfireDock(this.position(), this.icon(), (PlaceRequest)this.placeRequest(), this.perspective());
        return uberfireDock.withSize(400.0).withLabel(this.dockLabel());
    }

    String perspective() {
        return this.perspective;
    }

    UberfireDock getUberfireDock() {
        return this.uberfireDock;
    }

    UberfireDockPosition position() {
        return UberfireDockPosition.WEST;
    }

    private String icon() {
        return IconType.MAP.toString();
    }

    private String dockLabel() {
        return this.translationService.format("DecisionNavigatorPresenter.DecisionNavigator", new Object[0]);
    }

    private DefaultPlaceRequest placeRequest() {
        return new DefaultPlaceRequest("org.kie.dmn.decision.navigator");
    }
}

