/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions;

import com.ait.lienzo.client.core.event.INodeXYEvent;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.shared.core.types.EventPropagationMode;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.enterprise.event.Event;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.NOPDomainObject;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.commands.general.ClearExpressionTypeCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionContainerRenderer;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionContainerUIModelMapper;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionEditorColumn;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.ExpressionGridCache;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.HasListSelectorControl;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridRow;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.domainobject.DomainObject;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseHeaderMetaData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.BaseGridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridWidgetRegistry;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.GridPinnedModeManager;
import org.uberfire.mvp.ParameterizedCommand;

public class ExpressionContainerGrid
extends BaseGridWidget
implements HasListSelectorControl {
    private static final String COLUMN_GROUP = "ExpressionContainerGrid$Expression0";
    private final GridLayer gridLayer;
    private final CellEditorControlsView.Presenter cellEditorControls;
    private final TranslationService translationService;
    private final SessionManager sessionManager;
    private final SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    private final Supplier<ExpressionGridCache> expressionGridCache;
    private final GridCellTuple parent = new GridCellTuple(0, 0, (GridWidget)this);
    private final GridColumn expressionColumn;
    private String nodeUUID;
    private Optional<HasName> hasName = Optional.empty();
    private HasExpression hasExpression;
    private final ParameterizedCommand<Optional<Expression>> onHasExpressionChanged;
    private final ParameterizedCommand<Optional<HasName>> onHasNameChanged;
    private final Event<DomainObjectSelectionEvent> domainObjectSelectionEvent;
    private ExpressionContainerUIModelMapper uiModelMapper;

    public ExpressionContainerGrid(DMNGridLayer gridLayer, CellEditorControlsView.Presenter cellEditorControls, TranslationService translationService, ListSelectorView.Presenter listSelector, SessionManager sessionManager, SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, Supplier<ExpressionEditorDefinitions> expressionEditorDefinitions, Supplier<ExpressionGridCache> expressionGridCache, ParameterizedCommand<Optional<Expression>> onHasExpressionChanged, ParameterizedCommand<Optional<HasName>> onHasNameChanged, Event<DomainObjectSelectionEvent> domainObjectSelectionEvent) {
        super((GridData)new DMNGridData(), (GridSelectionManager)gridLayer, (GridPinnedModeManager)gridLayer, (GridRenderer)new ExpressionContainerRenderer());
        this.gridLayer = gridLayer;
        this.cellEditorControls = cellEditorControls;
        this.translationService = translationService;
        this.sessionManager = sessionManager;
        this.sessionCommandManager = sessionCommandManager;
        this.expressionGridCache = expressionGridCache;
        this.onHasExpressionChanged = onHasExpressionChanged;
        this.onHasNameChanged = onHasNameChanged;
        this.domainObjectSelectionEvent = domainObjectSelectionEvent;
        this.uiModelMapper = new ExpressionContainerUIModelMapper(this.parent, () -> ((ExpressionContainerGrid)this).getModel(), () -> Optional.ofNullable(this.hasExpression.getExpression()), () -> this.nodeUUID, () -> this.hasExpression, () -> this.hasName, expressionEditorDefinitions, expressionGridCache, listSelector);
        this.setEventPropagationMode(EventPropagationMode.NO_ANCESTORS);
        this.expressionColumn = new ExpressionEditorColumn((GridWidgetRegistry)gridLayer, (GridColumn.HeaderMetaData)new BaseHeaderMetaData(COLUMN_GROUP), (GridWidget)this);
        this.expressionColumn.setMovable(false);
        this.expressionColumn.setResizable(true);
        this.model.appendColumn(this.expressionColumn);
        this.model.appendRow((GridRow)new DMNGridRow());
        this.getRenderer().setColumnRenderConstraint((isSelectionLayer, gridColumn) -> isSelectionLayer == false || gridColumn.equals(this.expressionColumn));
    }

    public boolean onDragHandle(INodeXYEvent event) {
        return false;
    }

    public void deselect() {
        this.getModel().clearSelections();
        super.deselect();
    }

    public void setExpression(String nodeUUID, HasExpression hasExpression, Optional<HasName> hasName) {
        this.nodeUUID = nodeUUID;
        this.hasExpression = this.spyHasExpression(hasExpression);
        this.hasName = this.spyHasName(hasName);
        this.uiModelMapper.fromDMNModel(0, 0);
        this.expressionColumn.setWidth(this.getExistingEditorWidth());
        this.selectExpressionEditorFirstCell();
    }

    double getExistingEditorWidth() {
        ExpressionCellValue ecv;
        Optional editor;
        GridCellValue value;
        double existingWidth = 100.0;
        GridCell cell = (GridCell)this.model.getRow(0).getCells().get(0);
        if (cell != null && (value = cell.getValue()) instanceof ExpressionCellValue && (editor = (Optional)(ecv = (ExpressionCellValue)value).getValue()).isPresent()) {
            BaseExpressionGrid beg = (BaseExpressionGrid)editor.get();
            existingWidth = Math.max(existingWidth, beg.getWidth() + beg.getPadding() * 2.0);
        }
        return existingWidth;
    }

    HasExpression spyHasExpression(final HasExpression hasExpression) {
        HasExpression spy = new HasExpression(){

            public Expression getExpression() {
                return hasExpression.getExpression();
            }

            public void setExpression(Expression expression) {
                hasExpression.setExpression(expression);
                ExpressionContainerGrid.this.onHasExpressionChanged.execute(Optional.ofNullable(expression));
            }

            public DMNModelInstrumentedBase asDMNModelInstrumentedBase() {
                return hasExpression.asDMNModelInstrumentedBase();
            }

            public boolean isClearSupported() {
                return hasExpression.isClearSupported();
            }
        };
        return spy;
    }

    Optional<HasName> spyHasName(final Optional<HasName> hasName) {
        HasName spy = new HasName(){

            public Name getName() {
                return hasName.orElse(HasName.NOP).getName();
            }

            public void setName(Name name) {
                hasName.ifPresent(hn -> {
                    hn.setName(name);
                    ExpressionContainerGrid.this.onHasNameChanged.execute((Object)hasName);
                });
            }
        };
        return Optional.of(spy);
    }

    @Override
    public List<HasListSelectorControl.ListSelectorItem> getItems(int uiRowIndex, int uiColumnIndex) {
        if (this.hasExpression.isClearSupported()) {
            return Collections.singletonList(HasListSelectorControl.ListSelectorTextItem.build(this.translationService.format("ExpressionEditor.Clear", new Object[0]), true, () -> {
                this.cellEditorControls.hide();
                this.clearExpressionType();
            }));
        }
        return Collections.emptyList();
    }

    @Override
    public void onItemSelected(HasListSelectorControl.ListSelectorItem item) {
        HasListSelectorControl.ListSelectorTextItem li = (HasListSelectorControl.ListSelectorTextItem)item;
        li.getCommand().execute();
    }

    void clearExpressionType() {
        this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (Command)new ClearExpressionTypeCommand(this.parent, this.nodeUUID, this.hasExpression, this.uiModelMapper, this.expressionGridCache.get(), () -> {
            this.expressionColumn.setWidth(this.getExistingEditorWidth());
            this.selectExpressionEditorFirstCell();
        }, () -> {
            this.expressionColumn.setWidth(this.getExistingEditorWidth());
            this.selectExpressionEditorFirstCell();
        }));
    }

    void selectExpressionEditorFirstCell() {
        GridCellValue value = this.model.getCell(0, 0).getValue();
        Optional grid = (Optional)((ExpressionCellValue)value).getValue();
        grid.ifPresent(beg -> {
            Optional.ofNullable(this.getLayer()).ifPresent(layer -> ((DMNGridLayer)((Object)((Object)layer))).select((GridWidget)beg));
            beg.selectFirstCell();
        });
    }

    public boolean selectCell(Point2D ap, boolean isShiftKeyDown, boolean isControlKeyDown) {
        this.gridLayer.select((GridWidget)this);
        this.fireRefreshFormPropertiesEvent();
        return super.selectCell(ap, isShiftKeyDown, isControlKeyDown);
    }

    public boolean selectCell(int uiRowIndex, int uiColumnIndex, boolean isShiftKeyDown, boolean isControlKeyDown) {
        this.gridLayer.select((GridWidget)this);
        this.fireRefreshFormPropertiesEvent();
        return super.selectCell(uiRowIndex, uiColumnIndex, isShiftKeyDown, isControlKeyDown);
    }

    protected void fireRefreshFormPropertiesEvent() {
        CanvasHandler canvasHandler;
        ClientSession session = this.sessionManager.getCurrentSession();
        if (session != null && (canvasHandler = session.getCanvasHandler()) != null) {
            DMNModelInstrumentedBase base = this.hasExpression.asDMNModelInstrumentedBase();
            if (base instanceof DomainObject) {
                this.domainObjectSelectionEvent.fire((Object)new DomainObjectSelectionEvent(canvasHandler, (DomainObject)base));
                return;
            }
            this.domainObjectSelectionEvent.fire((Object)new DomainObjectSelectionEvent(canvasHandler, (DomainObject)new NOPDomainObject()));
        }
    }
}

