/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions;

import java.util.Objects;
import java.util.Optional;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.client.decision.DecisionNavigatorPresenter;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorView;
import org.kie.workbench.common.dmn.client.editors.toolbar.ToolbarStateHandler;
import org.kie.workbench.common.dmn.client.session.DMNSession;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasElementUpdatedEvent;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.uberfire.mvp.Command;

public class ExpressionEditor
implements ExpressionEditorView.Presenter {
    private ExpressionEditorView view;
    private Optional<Command> exitCommand = Optional.empty();
    private Optional<ToolbarStateHandler> toolbarStateHandler;
    private Optional<HasExpression> hasExpression = Optional.empty();
    private DecisionNavigatorPresenter decisionNavigator;

    public ExpressionEditor(ExpressionEditorView view, DecisionNavigatorPresenter decisionNavigator) {
        this.view = view;
        this.decisionNavigator = decisionNavigator;
        this.view.init(this);
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    public void bind(DMNSession session) {
        this.view.bind(session);
    }

    @Override
    public ExpressionEditorView getView() {
        return this.view;
    }

    @Override
    public void setToolbarStateHandler(ToolbarStateHandler toolbarStateHandler) {
        this.toolbarStateHandler = Optional.ofNullable(toolbarStateHandler);
    }

    @Override
    public void setExpression(String nodeUUID, HasExpression hasExpression, Optional<HasName> hasName) {
        this.hasExpression = Optional.ofNullable(hasExpression);
        this.view.setExpression(nodeUUID, hasExpression, hasName);
        this.toolbarStateHandler.ifPresent(ToolbarStateHandler::enterGridView);
    }

    @Override
    public void setExitCommand(Command exitCommand) {
        this.exitCommand = Optional.ofNullable(exitCommand);
    }

    @Override
    public void exit() {
        this.exitCommand.ifPresent(command -> {
            this.decisionNavigator.clearSelections();
            this.toolbarStateHandler.ifPresent(ToolbarStateHandler::enterGraphView);
            command.execute();
            this.exitCommand = Optional.empty();
        });
    }

    @Override
    public void handleCanvasElementUpdated(CanvasElementUpdatedEvent event) {
        Element element = event.getElement();
        if (element instanceof Node && element.getContent() instanceof Definition) {
            Definition definition = (Definition)element.getContent();
            this.hasExpression.ifPresent(e -> {
                if (Objects.equals(e, definition.getDefinition())) {
                    this.view.setReturnToDRGText(Optional.ofNullable((HasName)definition.getDefinition()));
                }
            });
        }
    }

    Optional<Command> getExitCommand() {
        return this.exitCommand;
    }
}

