/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions;

import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.client.decision.DecisionNavigatorPresenter;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditor;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorControl;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorView;
import org.kie.workbench.common.dmn.client.session.DMNSession;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.controls.AbstractCanvasControl;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasElementUpdatedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasSelectionEvent;

@Dependent
public class ExpressionEditorControlImpl
extends AbstractCanvasControl<AbstractCanvas>
implements ExpressionEditorControl {
    private ExpressionEditorView view;
    private DecisionNavigatorPresenter decisionNavigator;
    private Optional<ExpressionEditorView.Presenter> expressionEditor = Optional.empty();

    @Inject
    public ExpressionEditorControlImpl(ExpressionEditorView view, DecisionNavigatorPresenter decisionNavigator) {
        this.view = view;
        this.decisionNavigator = decisionNavigator;
    }

    public void bind(DMNSession session) {
        ExpressionEditorView.Presenter editor = this.makeExpressionEditor(this.view, this.decisionNavigator);
        editor.bind(session);
        this.expressionEditor = Optional.of(editor);
    }

    ExpressionEditorView.Presenter makeExpressionEditor(ExpressionEditorView view, DecisionNavigatorPresenter decisionNavigator) {
        return new ExpressionEditor(view, decisionNavigator);
    }

    protected void doInit() {
    }

    protected void doDestroy() {
        this.view = null;
        this.decisionNavigator = null;
        this.expressionEditor = Optional.empty();
    }

    @Override
    public ExpressionEditorView.Presenter getExpressionEditor() {
        if (this.expressionEditor.isPresent()) {
            return this.expressionEditor.get();
        }
        return null;
    }

    public void onCanvasFocusedSelectionEvent(@Observes CanvasSelectionEvent event) {
        this.expressionEditor.ifPresent(ExpressionEditorView.Presenter::exit);
    }

    public void onCanvasElementUpdated(@Observes CanvasElementUpdatedEvent event) {
        this.expressionEditor.ifPresent(editor -> editor.handleCanvasElementUpdated(event));
    }
}

