/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.hitpolicy;

import java.util.Arrays;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.kie.workbench.common.dmn.api.definition.v1_1.BuiltinAggregator;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionTableOrientation;
import org.kie.workbench.common.dmn.api.definition.v1_1.HitPolicy;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.hitpolicy.BuiltinAggregatorUtils;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.hitpolicy.HasHitPolicyControl;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.hitpolicy.HitPolicyPopoverView;

@ApplicationScoped
public class HitPolicyPopoverImpl
implements HitPolicyPopoverView.Presenter {
    private HitPolicyPopoverView view;
    private Optional<HasHitPolicyControl> binding = Optional.empty();

    public HitPolicyPopoverImpl() {
    }

    @Inject
    public HitPolicyPopoverImpl(HitPolicyPopoverView view, BuiltinAggregatorUtils builtinAggregatorUtils) {
        this.view = view;
        view.init(this);
        view.initHitPolicies(Arrays.asList(HitPolicy.values()));
        view.initBuiltinAggregators(builtinAggregatorUtils.getAllValues());
        view.initDecisionTableOrientations(Arrays.asList(DecisionTableOrientation.values()));
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    @Override
    public void bind(HasHitPolicyControl bound, int uiRowIndex, int uiColumnIndex) {
        this.binding = Optional.ofNullable(bound);
        this.refresh();
    }

    private void refresh() {
        this.binding.ifPresent(b -> {
            if (b.getHitPolicy() == null) {
                this.view.enableHitPolicies(false);
                this.view.enableBuiltinAggregators(false);
            } else {
                this.view.enableHitPolicies(true);
                this.view.initSelectedHitPolicy(b.getHitPolicy());
                this.view.enableBuiltinAggregators(HitPolicy.COLLECT.equals((Object)b.getHitPolicy()));
                this.view.initSelectedBuiltinAggregator(b.getBuiltinAggregator());
            }
            if (b.getDecisionTableOrientation() == null) {
                this.view.enableDecisionTableOrientation(false);
            } else {
                this.view.enableDecisionTableOrientation(true);
                this.view.initSelectedDecisionTableOrientation(b.getDecisionTableOrientation());
            }
        });
    }

    @Override
    public void setHitPolicy(HitPolicy hitPolicy) {
        this.binding.ifPresent(b -> b.setHitPolicy(hitPolicy, this::refresh));
    }

    @Override
    public void setBuiltinAggregator(BuiltinAggregator aggregator) {
        this.binding.ifPresent(b -> b.setBuiltinAggregator(aggregator));
    }

    @Override
    public void setDecisionTableOrientation(DecisionTableOrientation orientation) {
        this.binding.ifPresent(b -> b.setDecisionTableOrientation(orientation));
    }

    @Override
    public void show(Optional<String> editorTitle) {
        this.binding.ifPresent(b -> this.view.show(editorTitle));
    }

    @Override
    public void hide() {
        this.binding.ifPresent(b -> this.view.hide());
    }
}

