/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.function;

import java.util.Optional;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.api.definition.v1_1.FunctionDefinition;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.api.qualifiers.DMNEditor;
import org.kie.workbench.common.dmn.client.editors.expressions.types.BaseEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionType;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.FunctionGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.FunctionGridSupplementaryEditor;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.KindUtilities;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.parameters.ParametersPopoverView;
import org.kie.workbench.common.dmn.client.editors.types.NameAndDataTypePopoverView;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.dmn.client.widgets.grid.model.ExpressionEditorChanged;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.session.Session;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;

@ApplicationScoped
public class FunctionEditorDefinition
extends BaseEditorDefinition<FunctionDefinition, DMNGridData> {
    private Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    private Supplier<ExpressionEditorDefinitions> supplementaryEditorDefinitionsSupplier;
    private NameAndDataTypePopoverView.Presenter headerEditor;
    private ParametersPopoverView.Presenter parametersEditor;

    public FunctionEditorDefinition() {
    }

    @Inject
    public FunctionEditorDefinition(DefinitionUtils definitionUtils, SessionManager sessionManager, @Session SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory, Event<ExpressionEditorChanged> editorSelectedEvent, Event<DomainObjectSelectionEvent> domainObjectSelectionEvent, ListSelectorView.Presenter listSelector, TranslationService translationService, @DMNEditor Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier, @FunctionGridSupplementaryEditor Supplier<ExpressionEditorDefinitions> supplementaryEditorDefinitionsSupplier, NameAndDataTypePopoverView.Presenter headerEditor, ParametersPopoverView.Presenter parametersEditor) {
        super(definitionUtils, sessionManager, sessionCommandManager, canvasCommandFactory, editorSelectedEvent, domainObjectSelectionEvent, listSelector, translationService);
        this.expressionEditorDefinitionsSupplier = expressionEditorDefinitionsSupplier;
        this.supplementaryEditorDefinitionsSupplier = supplementaryEditorDefinitionsSupplier;
        this.headerEditor = headerEditor;
        this.parametersEditor = parametersEditor;
    }

    @Override
    public ExpressionType getType() {
        return ExpressionType.FUNCTION;
    }

    @Override
    public String getName() {
        return this.translationService.format("ExpressionEditor.FunctionType", new Object[0]);
    }

    @Override
    public Optional<FunctionDefinition> getModelClass() {
        return Optional.of(new FunctionDefinition());
    }

    @Override
    public void enrich(Optional<String> nodeUUID, HasExpression hasExpression, Optional<FunctionDefinition> expression) {
        expression.ifPresent(function -> {
            KindUtilities.setKind(function, FunctionDefinition.Kind.FEEL);
            LiteralExpression le = new LiteralExpression();
            function.setExpression((Expression)le);
            le.setParent((DMNModelInstrumentedBase)function);
        });
    }

    @Override
    public Optional<BaseExpressionGrid> getEditor(GridCellTuple parent, Optional<String> nodeUUID, HasExpression hasExpression, Optional<FunctionDefinition> expression, Optional<HasName> hasName, int nesting) {
        return Optional.of(new FunctionGrid(parent, nodeUUID, hasExpression, expression, hasName, this.getGridPanel(), this.getGridLayer(), this.makeGridData(expression), this.definitionUtils, this.sessionManager, (SessionCommandManager<AbstractCanvasHandler>)this.sessionCommandManager, (CanvasCommandFactory<AbstractCanvasHandler>)this.canvasCommandFactory, (Event<ExpressionEditorChanged>)this.editorSelectedEvent, (Event<DomainObjectSelectionEvent>)this.domainObjectSelectionEvent, this.getCellEditorControls(), this.listSelector, this.translationService, nesting, this.expressionEditorDefinitionsSupplier, this.supplementaryEditorDefinitionsSupplier, this.headerEditor, this.parametersEditor));
    }

    @Override
    protected DMNGridData makeGridData(Optional<FunctionDefinition> expression) {
        return new DMNGridData();
    }
}

