/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.function;

import com.ait.lienzo.shared.core.types.EventPropagationMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.enterprise.event.Event;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.api.definition.v1_1.FunctionDefinition;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.commands.expressions.types.function.AddParameterCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.function.ClearExpressionTypeCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.function.RemoveParameterCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.function.SetKindCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.function.UpdateParameterNameCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.function.UpdateParameterTypeRefCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionType;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.FunctionColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.FunctionColumnNameHeaderMetaData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.FunctionColumnParametersHeaderMetaData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.FunctionGridRenderer;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.FunctionUIModelMapper;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.KindUtilities;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.parameters.HasParametersControl;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.parameters.ParametersPopoverView;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.UndefinedExpressionGrid;
import org.kie.workbench.common.dmn.client.editors.types.NameAndDataTypePopoverView;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.HasListSelectorControl;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridRow;
import org.kie.workbench.common.dmn.client.widgets.grid.model.ExpressionEditorChanged;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellValueTuple;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.domainobject.DomainObject;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridWidgetRegistry;
import org.uberfire.mvp.Command;

public class FunctionGrid
extends BaseExpressionGrid<FunctionDefinition, DMNGridData, FunctionUIModelMapper>
implements HasListSelectorControl,
HasParametersControl {
    private final Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    private final Supplier<ExpressionEditorDefinitions> supplementaryEditorDefinitionsSupplier;
    private final NameAndDataTypePopoverView.Presenter headerEditor;
    private final ParametersPopoverView.Presenter parametersEditor;

    public FunctionGrid(GridCellTuple parent, Optional<String> nodeUUID, HasExpression hasExpression, Optional<FunctionDefinition> expression, Optional<HasName> hasName, DMNGridPanel gridPanel, DMNGridLayer gridLayer, DMNGridData gridData, DefinitionUtils definitionUtils, SessionManager sessionManager, SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory, Event<ExpressionEditorChanged> editorSelectedEvent, Event<DomainObjectSelectionEvent> domainObjectSelectionEvent, CellEditorControlsView.Presenter cellEditorControls, ListSelectorView.Presenter listSelector, TranslationService translationService, int nesting, Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier, Supplier<ExpressionEditorDefinitions> supplementaryEditorDefinitionsSupplier, NameAndDataTypePopoverView.Presenter headerEditor, ParametersPopoverView.Presenter parametersEditor) {
        super(parent, nodeUUID, hasExpression, expression, hasName, gridPanel, gridLayer, gridData, (GridRenderer)new FunctionGridRenderer(nesting > 0), definitionUtils, sessionManager, sessionCommandManager, canvasCommandFactory, editorSelectedEvent, domainObjectSelectionEvent, cellEditorControls, listSelector, translationService, nesting);
        this.expressionEditorDefinitionsSupplier = expressionEditorDefinitionsSupplier;
        this.supplementaryEditorDefinitionsSupplier = supplementaryEditorDefinitionsSupplier;
        this.headerEditor = headerEditor;
        this.parametersEditor = parametersEditor;
        this.setEventPropagationMode(EventPropagationMode.NO_ANCESTORS);
        super.doInitialisation();
    }

    @Override
    protected void doInitialisation() {
    }

    @Override
    public FunctionUIModelMapper makeUiModelMapper() {
        return new FunctionUIModelMapper((GridWidget)this, () -> ((FunctionGrid)this).getModel(), () -> this.expression, this.expressionEditorDefinitionsSupplier, this.supplementaryEditorDefinitionsSupplier, this.listSelector, this.nesting + 1);
    }

    @Override
    protected void initialiseUiColumns() {
        GridColumn.HeaderMetaData[] headerMetaDataArray = new GridColumn.HeaderMetaData[2];
        headerMetaDataArray[0] = new FunctionColumnNameHeaderMetaData(this.hasExpression, this.expression, (Optional<HasName>)this.hasName, this.clearDisplayNameConsumer(true), this.setDisplayNameConsumer(true), this.setTypeRefConsumer(), this.cellEditorControls, this.headerEditor, Optional.of(this.translationService.getTranslation("FunctionEditor.EditExpression")));
        headerMetaDataArray[1] = new FunctionColumnParametersHeaderMetaData(this.expression::get, this.translationService, this.cellEditorControls, this.parametersEditor, Optional.of(this.translationService.getTranslation("FunctionEditor.EditParameters")), this);
        FunctionColumn expressionColumn = new FunctionColumn((GridWidgetRegistry)this.gridLayer, Arrays.asList(headerMetaDataArray), (GridWidget)this);
        this.model.appendColumn((GridColumn)expressionColumn);
        this.getRenderer().setColumnRenderConstraint((arg_0, arg_1) -> FunctionGrid.lambda$initialiseUiColumns$1((GridColumn)expressionColumn, arg_0, arg_1));
    }

    @Override
    protected void initialiseUiModel() {
        this.expression.ifPresent(e -> {
            this.model.appendRow((GridRow)new DMNGridRow());
            ((FunctionUIModelMapper)this.uiModelMapper).fromDMNModel(0, 0);
        });
    }

    @Override
    protected boolean isHeaderHidden() {
        return false;
    }

    @Override
    public List<HasListSelectorControl.ListSelectorItem> getItems(int uiRowIndex, int uiColumnIndex) {
        ArrayList<HasListSelectorControl.ListSelectorItem> items = new ArrayList<HasListSelectorControl.ListSelectorItem>();
        FunctionDefinition.Kind kind = KindUtilities.getKind((FunctionDefinition)this.expression.get());
        items.add(HasListSelectorControl.ListSelectorTextItem.build(this.translationService.format("FunctionEditor.FEEL", new Object[0]), !FunctionDefinition.Kind.FEEL.equals((Object)kind), () -> {
            this.cellEditorControls.hide();
            this.expression.ifPresent(e -> this.setKind(FunctionDefinition.Kind.FEEL));
        }));
        items.add(HasListSelectorControl.ListSelectorTextItem.build(this.translationService.format("FunctionEditor.JAVA", new Object[0]), !FunctionDefinition.Kind.JAVA.equals((Object)kind), () -> {
            this.cellEditorControls.hide();
            this.expression.ifPresent(e -> this.setKind(FunctionDefinition.Kind.JAVA));
        }));
        items.add(HasListSelectorControl.ListSelectorTextItem.build(this.translationService.format("FunctionEditor.PMML", new Object[0]), !FunctionDefinition.Kind.PMML.equals((Object)kind), () -> {
            this.cellEditorControls.hide();
            this.expression.ifPresent(e -> this.setKind(FunctionDefinition.Kind.PMML));
        }));
        GridCell cell = this.model.getCell(uiRowIndex, uiColumnIndex);
        ExpressionCellValue ecv = (ExpressionCellValue)cell.getValue();
        if (!((Optional)ecv.getValue()).isPresent()) {
            return items;
        }
        BaseExpressionGrid grid = (BaseExpressionGrid)((Optional)ecv.getValue()).get();
        if (grid instanceof UndefinedExpressionGrid) {
            return items;
        }
        items.add(new HasListSelectorControl.ListSelectorDividerItem());
        items.add(HasListSelectorControl.ListSelectorTextItem.build(this.translationService.format("ExpressionEditor.Clear", new Object[0]), true, () -> {
            this.cellEditorControls.hide();
            this.clearExpressionType();
        }));
        return items;
    }

    @Override
    public void onItemSelected(HasListSelectorControl.ListSelectorItem item) {
        HasListSelectorControl.ListSelectorTextItem li = (HasListSelectorControl.ListSelectorTextItem)item;
        li.getCommand().execute();
    }

    @Override
    public List<InformationItem> getParameters() {
        ArrayList<InformationItem> parameters = new ArrayList<InformationItem>();
        this.expression.ifPresent(e -> parameters.addAll(e.getFormalParameter()));
        return parameters;
    }

    @Override
    public void addParameter(Command onSuccess) {
        this.expression.ifPresent(e -> {
            InformationItem parameter = new InformationItem();
            parameter.setName(new Name("p" + e.getFormalParameter().size()));
            this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (org.kie.workbench.common.stunner.core.command.Command)new AddParameterCommand((FunctionDefinition)e, parameter, () -> {
                this.gridLayer.batch();
                onSuccess.execute();
            }));
        });
    }

    @Override
    public void removeParameter(InformationItem parameter, Command onSuccess) {
        this.expression.ifPresent(e -> this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (org.kie.workbench.common.stunner.core.command.Command)new RemoveParameterCommand((FunctionDefinition)e, parameter, () -> {
            this.gridLayer.batch();
            onSuccess.execute();
        })));
    }

    @Override
    public void updateParameterName(InformationItem parameter, String name) {
        this.expression.ifPresent(e -> this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (org.kie.workbench.common.stunner.core.command.Command)new UpdateParameterNameCommand(parameter, name, this.gridLayer::batch)));
    }

    @Override
    public void updateParameterTypeRef(InformationItem parameter, QName typeRef) {
        this.expression.ifPresent(e -> this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (org.kie.workbench.common.stunner.core.command.Command)new UpdateParameterTypeRefCommand(parameter, typeRef, this.gridLayer::batch)));
    }

    void setKind(FunctionDefinition.Kind kind) {
        this.expression.ifPresent(function -> {
            switch (kind) {
                case FEEL: {
                    this.doSetKind(kind, (FunctionDefinition)function, this.expressionEditorDefinitionsSupplier.get().getExpressionEditorDefinition(ExpressionType.LITERAL_EXPRESSION));
                    break;
                }
                case JAVA: {
                    this.doSetKind(kind, (FunctionDefinition)function, this.supplementaryEditorDefinitionsSupplier.get().getExpressionEditorDefinition(ExpressionType.FUNCTION_JAVA));
                    break;
                }
                case PMML: {
                    this.doSetKind(kind, (FunctionDefinition)function, this.supplementaryEditorDefinitionsSupplier.get().getExpressionEditorDefinition(ExpressionType.FUNCTION_PMML));
                }
            }
        });
    }

    void doSetKind(FunctionDefinition.Kind kind, FunctionDefinition function, Optional<ExpressionEditorDefinition<Expression>> oDefinition) {
        oDefinition.ifPresent(definition -> {
            GridCellTuple expressionParent = new GridCellTuple(0, 0, (GridWidget)this);
            Optional<Expression> expression = definition.getModelClass();
            definition.enrich(this.nodeUUID, this.hasExpression, expression);
            Optional<BaseExpressionGrid> gridWidget = definition.getEditor(expressionParent, Optional.empty(), this.hasExpression, expression, this.hasName, this.nesting + 1);
            this.doSetKind(kind, function, expression, gridWidget);
        });
    }

    void doSetKind(FunctionDefinition.Kind kind, FunctionDefinition function, Optional<Expression> expression, Optional<BaseExpressionGrid> editor) {
        GridCellValueTuple<ExpressionCellValue> gcv = new GridCellValueTuple<ExpressionCellValue>(0, 0, (GridWidget)this, new ExpressionCellValue(editor));
        this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (org.kie.workbench.common.stunner.core.command.Command)new SetKindCommand(gcv, function, kind, expression, () -> {
            this.resize(BaseExpressionGrid.RESIZE_EXISTING_MINIMUM);
            editor.ifPresent(BaseExpressionGrid::selectFirstCell);
        }, () -> {
            this.resize(BaseExpressionGrid.RESIZE_EXISTING_MINIMUM);
            this.selectFirstCell();
        }));
    }

    void clearExpressionType() {
        this.expression.ifPresent(function -> {
            GridCellTuple gc = new GridCellTuple(0, 0, (GridWidget)this);
            this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (org.kie.workbench.common.stunner.core.command.Command)new ClearExpressionTypeCommand(gc, (FunctionDefinition)function, (FunctionUIModelMapper)this.uiModelMapper, () -> {
                this.resize(BaseExpressionGrid.RESIZE_EXISTING_MINIMUM);
                this.selectExpressionEditorFirstCell(0, 0);
            }, () -> {
                this.resize(BaseExpressionGrid.RESIZE_EXISTING_MINIMUM);
                this.selectExpressionEditorFirstCell(0, 0);
            }));
        });
    }

    @Override
    protected void doAfterSelectionChange(int uiRowIndex, int uiColumnIndex) {
        this.selectExpressionEditorFirstCell(0, 0);
    }

    @Override
    protected void doAfterHeaderSelectionChange(int uiHeaderRowIndex, int uiHeaderColumnIndex) {
        DMNModelInstrumentedBase base;
        if (uiHeaderRowIndex == 0 && (base = this.hasExpression.asDMNModelInstrumentedBase()) instanceof DomainObject) {
            this.fireDomainObjectSelectionEvent((DomainObject)base);
            return;
        }
        super.doAfterHeaderSelectionChange(uiHeaderRowIndex, uiHeaderColumnIndex);
    }

    private static /* synthetic */ Boolean lambda$initialiseUiColumns$1(GridColumn expressionColumn, Boolean isSelectionLayer, GridColumn gridColumn) {
        return isSelectionLayer == false || gridColumn.equals(expressionColumn);
    }
}

