/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.function;

import java.util.Optional;
import java.util.function.Supplier;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.api.definition.v1_1.FunctionDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.FunctionGridCell;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.BaseUIModelMapper;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;

public class FunctionUIModelMapper
extends BaseUIModelMapper<FunctionDefinition> {
    private final GridWidget gridWidget;
    private final Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    private final Supplier<ExpressionEditorDefinitions> supplementaryEditorDefinitionsSupplier;
    private final ListSelectorView.Presenter listSelector;
    private final int nesting;

    public FunctionUIModelMapper(GridWidget gridWidget, Supplier<GridData> uiModel, Supplier<Optional<FunctionDefinition>> dmnModel, Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier, Supplier<ExpressionEditorDefinitions> supplementaryEditorDefinitionsSupplier, ListSelectorView.Presenter listSelector, int nesting) {
        super(uiModel, dmnModel);
        this.gridWidget = gridWidget;
        this.expressionEditorDefinitionsSupplier = expressionEditorDefinitionsSupplier;
        this.supplementaryEditorDefinitionsSupplier = supplementaryEditorDefinitionsSupplier;
        this.listSelector = listSelector;
        this.nesting = nesting;
    }

    @Override
    public void fromDMNModel(int rowIndex, int columnIndex) {
        ((Optional)this.dmnModel.get()).ifPresent(function -> {
            FunctionDefinition.Kind kind = this.extractExpressionLanguage((FunctionDefinition)function);
            Optional<Expression> expression = Optional.ofNullable(function.getExpression());
            if (kind == null) {
                return;
            }
            switch (kind) {
                case FEEL: {
                    Optional<ExpressionEditorDefinition<Expression>> expressionEditorDefinition = this.expressionEditorDefinitionsSupplier.get().getExpressionEditorDefinition(expression);
                    expressionEditorDefinition.ifPresent(ed -> this.setUiModelEditor(rowIndex, columnIndex, (FunctionDefinition)function, (ExpressionEditorDefinition<Expression>)ed));
                    break;
                }
                case JAVA: 
                case PMML: {
                    Optional<ExpressionEditorDefinition<Expression>> supplementaryEditorDefinition = this.supplementaryEditorDefinitionsSupplier.get().getExpressionEditorDefinition(expression);
                    supplementaryEditorDefinition.ifPresent(ed -> this.setUiModelEditor(rowIndex, columnIndex, (FunctionDefinition)function, (ExpressionEditorDefinition<Expression>)ed));
                }
            }
        });
    }

    private void setUiModelEditor(int rowIndex, int columnIndex, FunctionDefinition function, ExpressionEditorDefinition<Expression> ed) {
        GridCellTuple expressionParent = new GridCellTuple(0, 0, this.gridWidget);
        Optional<Expression> expression = Optional.ofNullable(function.getExpression());
        Optional<BaseExpressionGrid> editor = ed.getEditor(expressionParent, Optional.empty(), (HasExpression)function, expression, Optional.empty(), this.nesting);
        ((GridData)this.uiModel.get()).setCell(rowIndex, columnIndex, () -> new FunctionGridCell(new ExpressionCellValue(editor), this.listSelector));
    }

    private FunctionDefinition.Kind extractExpressionLanguage(FunctionDefinition function) {
        String code = function.getKind() != null ? function.getKind().code() : FunctionDefinition.Kind.FEEL.code();
        return FunctionDefinition.Kind.determineFromString((String)code);
    }

    @Override
    public void toDMNModel(int rowIndex, int columnIndex, Supplier<Optional<GridCellValue<?>>> cell) {
        ((Optional)this.dmnModel.get()).ifPresent(function -> ((Optional)cell.get()).ifPresent(v -> {
            ExpressionCellValue ecv = (ExpressionCellValue)((Object)((Object)v));
            ((Optional)ecv.getValue()).ifPresent(beg -> function.setExpression((Expression)beg.getExpression().orElse(null)));
        }));
    }
}

