/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.function.parameters;

import com.google.gwt.user.client.Event;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.SinkNative;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.api.definition.HasTypeRef;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.parameters.ParameterView;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.parameters.ParametersPopoverView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.popover.AbstractPopoverViewImpl;
import org.uberfire.client.views.pfly.widgets.JQueryProducer;
import org.uberfire.client.views.pfly.widgets.Popover;
import org.uberfire.mvp.ParameterizedCommand;

@Templated
@ApplicationScoped
public class ParametersPopoverViewImpl
extends AbstractPopoverViewImpl
implements ParametersPopoverView {
    @DataField(value="parametersContainer")
    private Div parametersContainer;
    @DataField(value="addParameter")
    private Div addParameter;
    private ManagedInstance<ParameterView> parameterViews;
    private final List<ParameterView> parameterViewInstances = new ArrayList<ParameterView>();
    private ParametersPopoverView.Presenter presenter;

    public ParametersPopoverViewImpl() {
    }

    @Inject
    public ParametersPopoverViewImpl(Div parametersContainer, Div addParameter, ManagedInstance<ParameterView> parameterViews, Div popoverElement, Div popoverContentElement, JQueryProducer.JQuery<Popover> jQueryPopover) {
        super(popoverElement, popoverContentElement, jQueryPopover);
        this.parametersContainer = parametersContainer;
        this.addParameter = addParameter;
        this.parameterViews = parameterViews;
        this.popoverElement = popoverElement;
        this.popoverContentElement = popoverContentElement;
        this.jQueryPopover = jQueryPopover;
    }

    public void init(ParametersPopoverView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setParameters(List<InformationItem> parameters) {
        this.parameterViewInstances.clear();
        this.parameterViewInstances.addAll(parameters.stream().map(this::makeParameterView).collect(Collectors.toList()));
        DOMUtil.removeAllChildren((Node)this.parametersContainer);
        this.parameterViewInstances.forEach(parameterView -> this.parametersContainer.appendChild((Node)parameterView.getElement()));
    }

    private ParameterView makeParameterView(InformationItem parameter) {
        ParameterView parameterView = (ParameterView)this.parameterViews.get();
        parameterView.setName(parameter.getName().getValue());
        parameterView.setTypeRef((HasTypeRef)parameter);
        parameterView.addRemoveClickHandler(() -> this.presenter.removeParameter(parameter));
        parameterView.addParameterNameChangeHandler((ParameterizedCommand<String>)((ParameterizedCommand)name -> this.presenter.updateParameterName(parameter, (String)name)));
        parameterView.addParameterTypeRefChangeHandler((ParameterizedCommand<QName>)((ParameterizedCommand)typeRef -> this.presenter.updateParameterTypeRef(parameter, (QName)typeRef)));
        return parameterView;
    }

    @Override
    public void focusParameter(int index) {
        if (index < 0 || index >= this.parameterViewInstances.size()) {
            return;
        }
        this.parameterViewInstances.get(index).focus();
    }

    @EventHandler(value={"addParameter"})
    @SinkNative(value=1)
    public void onClickAddParameter(Event event) {
        this.presenter.addParameter();
    }
}

