/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.invocation;

import com.ait.lienzo.shared.core.types.EventPropagationMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.enterprise.event.Event;
import org.gwtbootstrap3.client.ui.TextArea;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.v1_1.Binding;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem;
import org.kie.workbench.common.dmn.api.definition.v1_1.Invocation;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.dmn.client.commands.expressions.types.invocation.AddParameterBindingCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.invocation.ClearExpressionTypeCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.invocation.DeleteParameterBindingCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionEditorColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.invocation.InvocationColumnExpressionHeaderMetaData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.invocation.InvocationColumnHeaderMetaData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.invocation.InvocationGridData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.invocation.InvocationGridRenderer;
import org.kie.workbench.common.dmn.client.editors.expressions.types.invocation.InvocationParameterColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.invocation.InvocationUIModelMapper;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.UndefinedExpressionGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.util.SelectionUtils;
import org.kie.workbench.common.dmn.client.editors.types.NameAndDataTypePopoverView;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.factory.dom.TextAreaDOMElement;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.HasListSelectorControl;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridRow;
import org.kie.workbench.common.dmn.client.widgets.grid.model.ExpressionEditorChanged;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.domainobject.DomainObject;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseHeaderMetaData;
import org.uberfire.ext.wires.core.grids.client.widget.dom.single.SingletonDOMElementFactory;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridWidgetRegistry;

public class InvocationGrid
extends BaseExpressionGrid<Invocation, InvocationGridData, InvocationUIModelMapper>
implements HasListSelectorControl {
    private static final String EXPRESSION_COLUMN_GROUP = "InvocationGrid$ExpressionColumn1";
    private final Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    private final NameAndDataTypePopoverView.Presenter headerEditor;

    public InvocationGrid(GridCellTuple parent, Optional<String> nodeUUID, HasExpression hasExpression, Optional<Invocation> expression, Optional<HasName> hasName, DMNGridPanel gridPanel, DMNGridLayer gridLayer, InvocationGridData gridData, DefinitionUtils definitionUtils, SessionManager sessionManager, SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory, Event<ExpressionEditorChanged> editorSelectedEvent, Event<DomainObjectSelectionEvent> domainObjectSelectionEvent, CellEditorControlsView.Presenter cellEditorControls, ListSelectorView.Presenter listSelector, TranslationService translationService, int nesting, Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier, NameAndDataTypePopoverView.Presenter headerEditor) {
        super(parent, nodeUUID, hasExpression, expression, hasName, gridPanel, gridLayer, gridData, (GridRenderer)new InvocationGridRenderer(nesting > 0), definitionUtils, sessionManager, sessionCommandManager, canvasCommandFactory, editorSelectedEvent, domainObjectSelectionEvent, cellEditorControls, listSelector, translationService, nesting);
        this.expressionEditorDefinitionsSupplier = expressionEditorDefinitionsSupplier;
        this.headerEditor = headerEditor;
        this.setEventPropagationMode(EventPropagationMode.NO_ANCESTORS);
        super.doInitialisation();
    }

    @Override
    protected void doInitialisation() {
    }

    @Override
    public InvocationUIModelMapper makeUiModelMapper() {
        return new InvocationUIModelMapper((GridWidget)this, () -> ((InvocationGrid)this).getModel(), () -> this.expression, this.expressionEditorDefinitionsSupplier, this.listSelector, this.nesting);
    }

    @Override
    protected void initialiseUiColumns() {
        InvocationColumnExpressionHeaderMetaData expressionHeaderMetaData = new InvocationColumnExpressionHeaderMetaData(this::getExpressionText, this::setExpressionText, (SingletonDOMElementFactory<TextArea, TextAreaDOMElement>)this.getHeaderTextAreaFactory());
        InvocationParameterColumn nameColumn = new InvocationParameterColumn(Arrays.asList(new InvocationColumnHeaderMetaData(this.hasExpression, this.expression, (Optional<HasName>)this.hasName, this.clearDisplayNameConsumer(true), this.setDisplayNameConsumer(true), this.setTypeRefConsumer(), this.cellEditorControls, this.headerEditor, Optional.of(this.translationService.getTranslation("InvocationEditor.EditExpression"))), expressionHeaderMetaData), this, rowIndex -> true, this.clearDisplayNameConsumer(false), this.setDisplayNameConsumer(false), this.setTypeRefConsumer(), this.cellEditorControls, this.headerEditor, Optional.of(this.translationService.getTranslation("InvocationEditor.EditParameter")));
        ExpressionEditorColumn expressionColumn = new ExpressionEditorColumn((GridWidgetRegistry)this.gridLayer, Arrays.asList(new BaseHeaderMetaData("", EXPRESSION_COLUMN_GROUP), expressionHeaderMetaData), (GridWidget)this);
        this.model.appendColumn((GridColumn)new RowNumberColumn());
        this.model.appendColumn((GridColumn)nameColumn);
        this.model.appendColumn((GridColumn)expressionColumn);
        this.getRenderer().setColumnRenderConstraint((isSelectionLayer, gridColumn) -> isSelectionLayer == false || gridColumn.equals((Object)expressionColumn));
    }

    private String getExpressionText() {
        return this.expression.map(invocation -> (LiteralExpression)invocation.getExpression()).map(LiteralExpression::getText).orElse(new Text()).getValue();
    }

    private void setExpressionText(String text) {
        this.expression.ifPresent(invocation -> ((LiteralExpression)invocation.getExpression()).getText().setValue(text));
    }

    @Override
    protected void initialiseUiModel() {
        this.expression.ifPresent(invocation -> invocation.getBinding().stream().forEach(binding -> {
            this.model.appendRow((GridRow)new DMNGridRow());
            ((InvocationUIModelMapper)this.uiModelMapper).fromDMNModel(this.model.getRowCount() - 1, 0);
            ((InvocationUIModelMapper)this.uiModelMapper).fromDMNModel(this.model.getRowCount() - 1, 1);
            ((InvocationUIModelMapper)this.uiModelMapper).fromDMNModel(this.model.getRowCount() - 1, 2);
        }));
    }

    @Override
    protected boolean isHeaderHidden() {
        return false;
    }

    @Override
    public List<HasListSelectorControl.ListSelectorItem> getItems(int uiRowIndex, int uiColumnIndex) {
        ArrayList<HasListSelectorControl.ListSelectorItem> items = new ArrayList<HasListSelectorControl.ListSelectorItem>();
        boolean isMultiRow = SelectionUtils.isMultiRow(this.model);
        boolean isMultiSelect = SelectionUtils.isMultiSelect(this.model);
        items.add(HasListSelectorControl.ListSelectorTextItem.build(this.translationService.format("InvocationEditor.InsertParameterAbove", new Object[0]), !isMultiRow, () -> {
            this.cellEditorControls.hide();
            this.expression.ifPresent(e -> this.addParameterBinding(uiRowIndex));
        }));
        items.add(HasListSelectorControl.ListSelectorTextItem.build(this.translationService.format("InvocationEditor.InsertParameterBelow", new Object[0]), !isMultiRow, () -> {
            this.cellEditorControls.hide();
            this.expression.ifPresent(e -> this.addParameterBinding(uiRowIndex + 1));
        }));
        items.add(HasListSelectorControl.ListSelectorTextItem.build(this.translationService.format("InvocationEditor.DeleteParameter", new Object[0]), !isMultiRow && this.model.getRowCount() > 1, () -> {
            this.cellEditorControls.hide();
            this.deleteParameterBinding(uiRowIndex);
        }));
        if (uiColumnIndex != 2) {
            return items;
        }
        GridCell cell = this.model.getCell(uiRowIndex, uiColumnIndex);
        ExpressionCellValue ecv = (ExpressionCellValue)cell.getValue();
        if (!((Optional)ecv.getValue()).isPresent()) {
            return items;
        }
        BaseExpressionGrid grid = (BaseExpressionGrid)((Optional)ecv.getValue()).get();
        if (grid instanceof UndefinedExpressionGrid) {
            return items;
        }
        items.add(new HasListSelectorControl.ListSelectorDividerItem());
        items.add(HasListSelectorControl.ListSelectorTextItem.build(this.translationService.format("ExpressionEditor.Clear", new Object[0]), !isMultiSelect, () -> {
            this.cellEditorControls.hide();
            this.clearExpressionType(uiRowIndex);
        }));
        return items;
    }

    @Override
    public void onItemSelected(HasListSelectorControl.ListSelectorItem item) {
        HasListSelectorControl.ListSelectorTextItem li = (HasListSelectorControl.ListSelectorTextItem)item;
        li.getCommand().execute();
    }

    void addParameterBinding(int index) {
        this.expression.ifPresent(invocation -> {
            Binding binding = new Binding();
            InformationItem parameter = new InformationItem();
            parameter.setName(new Name());
            binding.setParameter(parameter);
            CommandResult result = this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (Command)new AddParameterBindingCommand((Invocation)invocation, binding, this.model, new DMNGridRow(), index, (InvocationUIModelMapper)this.uiModelMapper, () -> this.resize(BaseExpressionGrid.RESIZE_EXISTING)));
            if (!CommandUtils.isError((CommandResult)result)) {
                this.selectCell(index, 1, false, false);
                this.startEditingCell(index, 1);
            }
        });
    }

    void deleteParameterBinding(int index) {
        this.expression.ifPresent(invocation -> this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (Command)new DeleteParameterBindingCommand((Invocation)invocation, this.model, index, () -> this.resize(BaseExpressionGrid.RESIZE_EXISTING))));
    }

    void clearExpressionType(int uiRowIndex) {
        GridCellTuple gc = new GridCellTuple(uiRowIndex, 2, (GridWidget)this);
        this.expression.ifPresent(invocation -> {
            HasExpression hasExpression = (HasExpression)invocation.getBinding().get(uiRowIndex);
            this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (Command)new ClearExpressionTypeCommand(gc, hasExpression, (InvocationUIModelMapper)this.uiModelMapper, () -> {
                this.resize(BaseExpressionGrid.RESIZE_EXISTING_MINIMUM);
                this.selectExpressionEditorFirstCell(uiRowIndex, 2);
            }, () -> {
                this.resize(BaseExpressionGrid.RESIZE_EXISTING_MINIMUM);
                this.selectExpressionEditorFirstCell(uiRowIndex, 2);
            }));
        });
    }

    @Override
    protected void doAfterSelectionChange(int uiRowIndex, int uiColumnIndex) {
        if (this.hasAnyHeaderCellSelected() || this.hasMultipleCellsSelected()) {
            super.doAfterSelectionChange(uiRowIndex, uiColumnIndex);
            return;
        }
        if (uiColumnIndex == 1 && this.expression.isPresent()) {
            Invocation invocation = (Invocation)this.expression.get();
            this.fireDomainObjectSelectionEvent((DomainObject)((Binding)invocation.getBinding().get(uiRowIndex)).getVariable());
            return;
        }
        super.doAfterSelectionChange(uiRowIndex, uiColumnIndex);
    }

    @Override
    protected void doAfterHeaderSelectionChange(int uiHeaderRowIndex, int uiHeaderColumnIndex) {
        DMNModelInstrumentedBase base;
        if (uiHeaderRowIndex == 0 && uiHeaderColumnIndex == 1 && (base = this.hasExpression.asDMNModelInstrumentedBase()) instanceof DomainObject) {
            this.fireDomainObjectSelectionEvent((DomainObject)base);
            return;
        }
        super.doAfterHeaderSelectionChange(uiHeaderRowIndex, uiHeaderColumnIndex);
    }
}

