/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.relation;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.kie.soup.commons.util.Lists;
import org.kie.workbench.common.dmn.api.definition.v1_1.Relation;
import org.kie.workbench.common.dmn.client.commands.expressions.types.relation.MoveColumnsCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.relation.MoveRowsCommand;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DelegatingGridData;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.mvp.Command;

public class RelationGridData
extends DelegatingGridData {
    private final SessionManager sessionManager;
    private final SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    private final Optional<Relation> expression;
    private final Command canvasOperation;

    public RelationGridData(DMNGridData delegate, SessionManager sessionManager, SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, Optional<Relation> expression, Command canvasOperation) {
        super(delegate);
        this.sessionManager = sessionManager;
        this.sessionCommandManager = sessionCommandManager;
        this.expression = expression;
        this.canvasOperation = canvasOperation;
    }

    @Override
    public void moveRowTo(int index, GridRow row) {
        this.moveRowsTo(index, Collections.singletonList(row));
    }

    @Override
    public void moveRowsTo(int index, List<GridRow> rows) {
        this.expression.ifPresent(relation -> this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (org.kie.workbench.common.stunner.core.command.Command)new MoveRowsCommand((Relation)relation, this.delegate, index, rows, this.canvasOperation)));
    }

    @Override
    public void moveColumnTo(int index, GridColumn<?> column) {
        this.moveColumnsTo(index, new Lists.Builder().add(column).build());
    }

    @Override
    public void moveColumnsTo(int index, List<GridColumn<?>> columns) {
        this.expression.ifPresent(relation -> this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (org.kie.workbench.common.stunner.core.command.Command)new MoveColumnsCommand((Relation)relation, this.delegate, index, columns, this.canvasOperation)));
    }

    @Override
    public void appendColumn(GridColumn<?> column) {
        this.delegate.appendColumn(column);
        this.assertResizableColumns();
    }

    @Override
    public void insertColumn(int index, GridColumn<?> column) {
        this.delegate.insertColumn(index, column);
        this.assertResizableColumns();
    }

    @Override
    public void deleteColumn(GridColumn<?> column) {
        this.delegate.deleteColumn(column);
        this.assertResizableColumns();
    }

    private void assertResizableColumns() {
        int lastColumnIndex = this.getColumnCount() - 1;
        for (int columnIndex = 0; columnIndex < this.getColumnCount(); ++columnIndex) {
            GridColumn<?> uiColumn = this.getColumns().get(columnIndex);
            uiColumn.setResizable(columnIndex != lastColumnIndex);
        }
    }
}

