/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.undefined;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.UndefinedExpressionColumnRenderer;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.UndefinedExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.HasCellEditorControls;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.HasListSelectorControl;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellEditContext;

public class UndefinedExpressionColumn
extends DMNGridColumn<UndefinedExpressionGrid, String>
implements HasListSelectorControl {
    private final CellEditorControlsView.Presenter cellEditorControls;
    private final Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;

    public UndefinedExpressionColumn(GridColumn.HeaderMetaData headerMetaData, UndefinedExpressionGrid gridWidget, CellEditorControlsView.Presenter cellEditorControls, Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier) {
        this(Collections.singletonList(headerMetaData), gridWidget, cellEditorControls, expressionEditorDefinitionsSupplier);
    }

    public UndefinedExpressionColumn(List<GridColumn.HeaderMetaData> headerMetaData, UndefinedExpressionGrid gridWidget, CellEditorControlsView.Presenter cellEditorControls, Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier) {
        super(headerMetaData, new UndefinedExpressionColumnRenderer(), gridWidget);
        this.cellEditorControls = cellEditorControls;
        this.expressionEditorDefinitionsSupplier = expressionEditorDefinitionsSupplier;
    }

    public void edit(GridCell<String> cell, GridBodyCellEditContext context, Consumer<GridCellValue<String>> callback) {
        int uiRowIndex = context.getRowIndex();
        int uiColumnIndex = context.getColumnIndex();
        double absoluteCellX = context.getAbsoluteCellX();
        double absoluteCellY = context.getAbsoluteCellY();
        if (cell == null) {
            return;
        }
        if (cell instanceof HasCellEditorControls) {
            HasCellEditorControls hasControls = (HasCellEditorControls)cell;
            Optional<HasCellEditorControls.Editor> editor = hasControls.getEditor();
            editor.ifPresent(e -> {
                e.bind(this, uiRowIndex, uiColumnIndex);
                double[] dxy = new double[]{absoluteCellX, absoluteCellY};
                Optional rx = context.getRelativeLocation();
                rx.ifPresent(r -> {
                    dxy[0] = r.getX();
                    dxy[1] = r.getY();
                });
                this.cellEditorControls.show((HasCellEditorControls.Editor<?>)e, Optional.empty(), (int)dxy[0], (int)dxy[1]);
            });
        }
    }

    public void setWidth(double width) {
        super.setWidth(width);
        this.updateWidthOfPeers();
    }

    @Override
    public List<HasListSelectorControl.ListSelectorItem> getItems(int uiRowIndex, int uiColumnIndex) {
        ArrayList<HasListSelectorControl.ListSelectorItem> items = new ArrayList<HasListSelectorControl.ListSelectorItem>();
        items.addAll(this.expressionEditorDefinitionsSupplier.get().stream().filter(definition -> definition.getModelClass().isPresent()).map(this::makeListSelectorItem).collect(Collectors.toList()));
        return items;
    }

    HasListSelectorControl.ListSelectorTextItem makeListSelectorItem(ExpressionEditorDefinition definition) {
        return HasListSelectorControl.ListSelectorTextItem.build(definition.getName(), true, () -> {
            this.cellEditorControls.hide();
            ((UndefinedExpressionGrid)this.gridWidget).onExpressionTypeChanged(definition.getType());
        });
    }

    @Override
    public void onItemSelected(HasListSelectorControl.ListSelectorItem item) {
        if (item instanceof HasListSelectorControl.ListSelectorTextItem) {
            HasListSelectorControl.ListSelectorTextItem li = (HasListSelectorControl.ListSelectorTextItem)item;
            li.getCommand().execute();
        }
    }
}

