/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.util;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.ITextWrapper;
import com.ait.lienzo.client.core.shape.Text;
import com.ait.lienzo.client.core.shape.TextLineBreakWrap;
import com.ait.lienzo.shared.core.types.TextAlign;
import com.google.gwt.core.client.GWT;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.InformationItemCell;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.NameAndDataTypeHeaderMetaData;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridHeaderColumnRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.themes.GridRendererTheme;

public class RendererUtils {
    public static final String FONT_STYLE_TYPE_REF = "italic";
    public static final double SPACING = 8.0;

    public static Group getExpressionCellText(GridBodyCellRenderContext context, GridCell<String> gridCell) {
        GridRenderer gridRenderer = context.getRenderer();
        GridRendererTheme theme = gridRenderer.getTheme();
        Group g = (Group)GWT.create(Group.class);
        Text t = theme.getBodyText();
        t.setText((String)gridCell.getValue().getValue());
        t.setListening(false);
        t.setX(5.0);
        t.setY(5.0);
        t.setFontFamily("Courier New");
        t.setTextAlign(TextAlign.LEFT);
        t.setWrapper((ITextWrapper)new TextLineBreakWrap(t));
        g.add((IPrimitive)t);
        return g;
    }

    public static Group getCenteredCellText(GridBodyCellRenderContext context, GridCell<String> gridCell) {
        GridRenderer gridRenderer = context.getRenderer();
        GridRendererTheme theme = gridRenderer.getTheme();
        Group g = (Group)GWT.create(Group.class);
        Text t = theme.getBodyText();
        t.setText((String)gridCell.getValue().getValue());
        t.setListening(false);
        t.setX(context.getCellWidth() / 2.0);
        t.setY(context.getCellHeight() / 2.0);
        g.add((IPrimitive)t);
        return g;
    }

    public static Group getNameAndDataTypeText(NameAndDataTypeHeaderMetaData headerMetaData, GridHeaderColumnRenderContext context, double blockWidth, double blockHeight) {
        return RendererUtils.getNameAndDataTypeText(context.getRenderer().getTheme(), headerMetaData.getTitle(), headerMetaData.getTypeRef(), blockWidth, blockHeight);
    }

    public static Group getNameAndDataTypeText(InformationItemCell.HasNameAndDataTypeCell hasNameAndDataTypeCell, GridBodyCellRenderContext context) {
        return RendererUtils.getNameAndDataTypeText(context.getRenderer().getTheme(), hasNameAndDataTypeCell.getName().getValue(), hasNameAndDataTypeCell.getTypeRef(), context.getCellWidth(), context.getCellHeight());
    }

    private static Group getNameAndDataTypeText(GridRendererTheme theme, String name, QName typeRef, double blockWidth, double blockHeight) {
        Group headerGroup = (Group)GWT.create(Group.class);
        Text tName = theme.getHeaderText();
        tName.setText(name);
        tName.setListening(false);
        tName.setX(blockWidth / 2.0);
        tName.setY(blockHeight / 2.0 - 8.0);
        Text tTypeRef = theme.getHeaderText();
        tTypeRef.setFontStyle(FONT_STYLE_TYPE_REF);
        tTypeRef.setFontSize(8.0);
        tTypeRef.setText("(" + typeRef.toString() + ")");
        tTypeRef.setListening(false);
        tTypeRef.setX(blockWidth / 2.0);
        tTypeRef.setY(blockHeight / 2.0 + 8.0);
        headerGroup.add((IPrimitive)tName);
        headerGroup.add((IPrimitive)tTypeRef);
        return headerGroup;
    }
}

