/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types;

import elemental2.dom.Element;
import elemental2.dom.HTMLElement;
import elemental2.dom.Node;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManager;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManagerStackStore;
import org.kie.workbench.common.dmn.client.editors.types.common.ItemDefinitionUtils;
import org.kie.workbench.common.dmn.client.editors.types.common.JQuery;
import org.kie.workbench.common.dmn.client.editors.types.common.JQueryEvent;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeList;
import org.kie.workbench.common.dmn.client.editors.types.messages.DataTypeFlashMessages;
import org.kie.workbench.common.dmn.client.editors.types.persistence.DataTypeStore;
import org.kie.workbench.common.dmn.client.editors.types.persistence.ItemDefinitionStore;
import org.uberfire.ext.editor.commons.client.file.popups.elemental2.Elemental2Modal;

@ApplicationScoped
public class DataTypeModal
extends Elemental2Modal<View> {
    private final DataTypeList treeList;
    private final ItemDefinitionUtils itemDefinitionUtils;
    private final ItemDefinitionStore definitionStore;
    private final DataTypeStore dataTypeStore;
    private final DataTypeManager dataTypeManager;
    private final DataTypeManagerStackStore stackIndex;
    private final DataTypeFlashMessages flashMessages;

    @Inject
    public DataTypeModal(View view, DataTypeList treeList, ItemDefinitionUtils itemDefinitionUtils, ItemDefinitionStore definitionStore, DataTypeStore dataTypeStore, DataTypeManager dataTypeManager, DataTypeManagerStackStore stackIndex, DataTypeFlashMessages flashMessages) {
        super((Elemental2Modal.View)view);
        this.treeList = treeList;
        this.itemDefinitionUtils = itemDefinitionUtils;
        this.definitionStore = definitionStore;
        this.dataTypeStore = dataTypeStore;
        this.dataTypeManager = dataTypeManager;
        this.stackIndex = stackIndex;
        this.flashMessages = flashMessages;
    }

    @PostConstruct
    public void setup() {
        super.setup();
        this.setDataTypeModalCSSClasses();
        ((View)this.getView()).setup(this.flashMessages, this.treeList);
    }

    public void show() {
        this.setupOnCloseCallback();
        this.cleanDataTypeStore();
        this.loadDataTypes();
        this.superShow();
    }

    void cleanDataTypeStore() {
        this.definitionStore.clear();
        this.dataTypeStore.clear();
        this.stackIndex.clear();
    }

    void loadDataTypes() {
        this.treeList.setupItems(this.itemDefinitionUtils.all().stream().map(this::makeDataType).collect(Collectors.toList()));
    }

    DataType makeDataType(ItemDefinition itemDefinition) {
        return this.dataTypeManager.from(itemDefinition).get();
    }

    void superShow() {
        super.show();
    }

    void setDataTypeModalCSSClasses() {
        Element modalDialogElement = this.getModalDialogElement();
        modalDialogElement.classList.add(new String[]{"kie-data-types-modal"});
    }

    void onCloseEvent(JQueryEvent event) {
        this.flashMessages.hideMessages();
    }

    Element getModalDialogElement() {
        HTMLElement body = ((View)this.getView()).getBody();
        Node modalBodyNode = body.parentNode;
        Node modalContentNode = modalBodyNode.parentNode;
        Node modalDialogNode = modalContentNode.parentNode;
        Node modalParentNode = modalDialogNode.parentNode;
        return modalParentNode.querySelector(".modal-dialog");
    }

    void setupOnCloseCallback() {
        JQuery.$(this.getModalDialogElement().parentNode).on("hidden.bs.modal", this::onCloseEvent);
    }

    public static interface View
    extends Elemental2Modal.View<DataTypeModal> {
        public void setup(DataTypeFlashMessages var1, DataTypeList var2);
    }
}

