/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.common;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.v1_1.Definitions;
import org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition;
import org.kie.workbench.common.dmn.api.definition.v1_1.UnaryTests;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;

@Dependent
public class ItemDefinitionUtils {
    private final DMNGraphUtils dmnGraphUtils;

    @Inject
    public ItemDefinitionUtils(DMNGraphUtils dmnGraphUtils) {
        this.dmnGraphUtils = dmnGraphUtils;
    }

    public Optional<ItemDefinition> findByName(String name) {
        return this.all().stream().filter(itemDefinition -> itemDefinition.getName().getValue().equals(name)).findFirst();
    }

    public List<ItemDefinition> all() {
        if (this.dmnGraphUtils.getDefinitions() != null) {
            return this.dmnGraphUtils.getDefinitions().getItemDefinition();
        }
        return Collections.emptyList();
    }

    public String getConstraintText(ItemDefinition itemDefinition) {
        return Optional.ofNullable(itemDefinition.getAllowedValues()).map(UnaryTests::getText).orElse(new Text()).getValue();
    }

    public QName normaliseTypeRef(QName typeRef) {
        String namespace = typeRef.getNamespaceURI();
        String localPart = typeRef.getLocalPart();
        String typeRefPrefix = typeRef.getPrefix();
        Optional<String> nsPrefix = this.getPrefixForNamespaceURI(namespace);
        return nsPrefix.map(prefix -> new QName("", localPart, prefix)).orElseGet(() -> new QName(namespace, localPart, typeRefPrefix));
    }

    Optional<String> getPrefixForNamespaceURI(String namespace) {
        Definitions definitions = this.dmnGraphUtils.getDefinitions();
        return definitions == null ? Optional.empty() : definitions.getPrefixForNamespaceURI(namespace);
    }
}

