/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import elemental2.dom.Element;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLInputElement;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.client.editors.types.common.HiddenHelper;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeConstraint;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeSelect;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.JQueryTooltip;

@Dependent
@Templated
public class DataTypeConstraintView
implements DataTypeConstraint.View {
    @DataField(value="constraint-toggle")
    private final HTMLInputElement constraintToggle;
    @DataField(value="constraint-value")
    private final HTMLInputElement constraintValue;
    @DataField(value="constraints-tooltip")
    private final HTMLElement constraintsTooltip;
    private final TranslationService translationService;
    private DataTypeSelect presenter;

    @Inject
    public DataTypeConstraintView(TranslationService translationService, HTMLInputElement constraintToggle, HTMLInputElement constraintValue, @Named(value="span") HTMLElement constraintsTooltip) {
        this.translationService = translationService;
        this.constraintToggle = constraintToggle;
        this.constraintValue = constraintValue;
        this.constraintsTooltip = constraintsTooltip;
    }

    public void init(DataTypeSelect presenter) {
        this.presenter = presenter;
    }

    @PostConstruct
    public void setup() {
        this.constraintsTooltip.setAttribute("title", this.translationService.format("DataTypeConstraintView.ConstraintsTooltip", new Object[0]));
        this.setupTooltip(this.properties().getJavaScriptObject());
    }

    @EventHandler(value={"constraint-toggle"})
    public void onConstraintToggleChange(ChangeEvent e) {
        if (this.constraintToggle.checked) {
            this.enableConstraint();
            this.constraintValue.select();
        } else {
            this.disableConstraint();
            this.constraintValue.value = "";
        }
    }

    @Override
    public void enableConstraint() {
        this.constraintToggle.checked = true;
        HiddenHelper.show((Element)this.constraintValue);
    }

    @Override
    public void disableConstraint() {
        this.constraintToggle.checked = false;
        HiddenHelper.hide((Element)this.constraintValue);
    }

    @Override
    public String getConstraintValue() {
        return this.constraintValue.value;
    }

    @Override
    public void setConstraintValue(String value) {
        this.constraintValue.value = value;
    }

    void setupTooltip(JavaScriptObject javaScriptObject) {
        JQueryTooltip.$((Element)this.constraintsTooltip).tooltip(javaScriptObject);
    }

    JSONObject properties() {
        JSONObject jsonObject = this.makeJsonObject();
        jsonObject.put("container", (JSONValue)new JSONString("body"));
        return jsonObject;
    }

    JSONObject makeJsonObject() {
        return new JSONObject();
    }
}

