/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview;

import elemental2.dom.HTMLElement;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManager;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeConstraint;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeList;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeSelect;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.SmallSwitchComponent;
import org.kie.workbench.common.dmn.client.editors.types.listview.confirmation.DataTypeConfirmation;
import org.kie.workbench.common.dmn.client.editors.types.persistence.CreationType;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.mvp.Command;

public class DataTypeListItem {
    private final View view;
    private final DataTypeSelect dataTypeSelectComponent;
    private final DataTypeConstraint dataTypeConstraintComponent;
    private final SmallSwitchComponent dataTypeCollectionComponent;
    private final DataTypeManager dataTypeManager;
    private final DataTypeConfirmation confirmation;
    private DataType dataType;
    private int level;
    private DataTypeList dataTypeList;
    private String oldName;
    private String oldType;
    private String oldConstraint;
    private boolean oldIsCollection;

    @Inject
    public DataTypeListItem(View view, DataTypeSelect dataTypeSelectComponent, DataTypeConstraint dataTypeConstraintComponent, SmallSwitchComponent dataTypeCollectionComponent, DataTypeManager dataTypeManager, DataTypeConfirmation confirmation) {
        this.view = view;
        this.dataTypeSelectComponent = dataTypeSelectComponent;
        this.dataTypeConstraintComponent = dataTypeConstraintComponent;
        this.dataTypeCollectionComponent = dataTypeCollectionComponent;
        this.dataTypeManager = dataTypeManager;
        this.confirmation = confirmation;
    }

    @PostConstruct
    void setup() {
        this.view.init(this);
    }

    public void init(DataTypeList dataTypeList) {
        this.dataTypeList = dataTypeList;
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    void setupDataType(DataType dataType, int level) {
        this.dataType = dataType;
        this.level = level;
        this.setupSelectComponent();
        this.setupConstraintComponent();
        this.setupCollectionComponent();
        this.setupView();
    }

    void setupCollectionComponent() {
        this.dataTypeCollectionComponent.setValue(this.getDataType().isCollection());
        this.refreshCollectionYesLabel();
    }

    void setupConstraintComponent() {
        this.dataTypeConstraintComponent.init(this.getDataType());
    }

    void setupSelectComponent() {
        this.dataTypeSelectComponent.init(this, this.getDataType());
    }

    void setupView() {
        this.view.setupSelectComponent(this.dataTypeSelectComponent);
        this.view.setupConstraintComponent(this.dataTypeConstraintComponent);
        this.view.setupCollectionComponent(this.dataTypeCollectionComponent);
        this.view.setDataType(this.getDataType());
    }

    void refresh() {
        this.dataTypeSelectComponent.refresh();
        this.dataTypeSelectComponent.init(this, this.getDataType());
        this.view.setName(this.getDataType().getName());
        this.view.setConstraint(this.getDataType().getConstraint());
        this.setupCollectionComponent();
        this.setupConstraintComponent();
    }

    DataType getDataType() {
        return this.dataType;
    }

    public int getLevel() {
        return this.level;
    }

    void expandOrCollapseSubTypes() {
        if (this.view.isCollapsed()) {
            this.expand();
        } else {
            this.collapse();
        }
    }

    void expand() {
        this.view.expand();
    }

    void collapse() {
        this.view.collapse();
    }

    void refreshSubItems(List<DataType> dataTypes) {
        this.dataTypeList.refreshSubItemsFromListItem(this, dataTypes);
        this.view.enableFocusMode();
        this.view.toggleArrow(!dataTypes.isEmpty());
    }

    void enableEditMode() {
        this.oldName = this.getDataType().getName();
        this.oldType = this.getDataType().getType();
        this.oldConstraint = this.getDataType().getConstraint();
        this.oldIsCollection = this.getDataType().isCollection();
        this.view.showSaveButton();
        this.view.showDataTypeNameInput();
        this.view.showConstraintContainer();
        this.view.hideConstraintText();
        this.view.enableFocusMode();
        this.view.hideCollectionYesLabel();
        this.view.showCollectionContainer();
        this.dataTypeSelectComponent.enableEditMode();
        this.dataTypeConstraintComponent.refreshView();
    }

    void disableEditMode() {
        this.discardNewDataType();
        this.closeEditMode();
    }

    void saveAndCloseEditMode() {
        DataType updatedDataType = this.updateProperties(this.getDataType());
        if (updatedDataType.isValid()) {
            this.confirmation.ifDataTypeDoesNotHaveLostSubDataTypes(updatedDataType, this.doSaveAndCloseEditMode(updatedDataType), this.doDisableEditMode());
        }
    }

    Command doDisableEditMode() {
        return this::disableEditMode;
    }

    Command doSaveAndCloseEditMode(DataType dataType) {
        return () -> {
            List<DataType> updateDataTypes = this.persist(dataType);
            this.dataTypeList.refreshItemsByUpdatedDataTypes(updateDataTypes);
            this.closeEditMode();
        };
    }

    List<DataType> persist(DataType dataType) {
        return this.dataTypeManager.from(dataType).withSubDataTypes(this.dataTypeSelectComponent.getSubDataTypes()).get().update();
    }

    void discardNewDataType() {
        this.view.setDataType(this.dataTypeManager.withDataType(this.getDataType()).withName(this.getOldName()).withType(this.getOldType()).withConstraint(this.getOldConstraint()).asCollection(this.getOldIsCollection()).get());
        this.setupCollectionComponent();
        this.setupSelectComponent();
        this.refreshSubItems(this.getDataType().getSubDataTypes());
    }

    void closeEditMode() {
        this.view.showEditButton();
        this.view.hideDataTypeNameInput();
        this.view.disableFocusMode();
        this.view.hideConstraintContainer();
        this.view.showConstraintText();
        this.view.hideCollectionContainer();
        this.refreshCollectionYesLabel();
        this.dataTypeSelectComponent.disableEditMode();
    }

    void refreshCollectionYesLabel() {
        if (this.getDataType().isCollection()) {
            this.view.showCollectionYesLabel();
        } else {
            this.view.hideCollectionYesLabel();
        }
    }

    public void remove() {
        this.confirmation.ifIsNotReferencedDataType(this.getDataType(), this.doRemove());
    }

    Command doRemove() {
        return () -> {
            List<DataType> destroyedDataTypes = this.getDataType().destroy();
            List<DataType> removedDataTypes = this.removeTopLevelDataTypes(destroyedDataTypes);
            destroyedDataTypes.removeAll(removedDataTypes);
            this.dataTypeList.refreshItemsByUpdatedDataTypes(destroyedDataTypes);
        };
    }

    List<DataType> removeTopLevelDataTypes(List<DataType> destroyedDataTypes) {
        String destroyedType = this.getDataType().getName();
        return destroyedDataTypes.stream().filter(dt -> dt.isTopLevel() && (Objects.equals(dt.getName(), destroyedType) || Objects.equals(dt.getType(), destroyedType))).peek(this.dataTypeList::removeItem).collect(Collectors.toList());
    }

    DataType updateProperties(DataType dataType) {
        return this.dataTypeManager.from(dataType).withName(this.view.getName()).withType(this.dataTypeSelectComponent.getValue()).withConstraint(this.dataTypeConstraintComponent.getValue()).asCollection(this.dataTypeCollectionComponent.getValue()).get();
    }

    String getOldName() {
        return this.oldName;
    }

    String getOldType() {
        return this.oldType;
    }

    String getOldConstraint() {
        return this.oldConstraint;
    }

    boolean getOldIsCollection() {
        return this.oldIsCollection;
    }

    DataTypeList getDataTypeList() {
        return this.dataTypeList;
    }

    void insertFieldAbove() {
        this.closeEditMode();
        DataType newDataType = this.newDataType();
        List<DataType> updatedDataTypes = newDataType.create(this.getDataType(), CreationType.ABOVE);
        if (newDataType.isTopLevel()) {
            this.dataTypeList.insertAbove(newDataType, this.getDataType());
        } else {
            this.dataTypeList.refreshItemsByUpdatedDataTypes(updatedDataTypes);
        }
    }

    void insertFieldBelow() {
        this.closeEditMode();
        DataType newDataType = this.newDataType();
        List<DataType> updatedDataTypes = newDataType.create(this.getDataType(), CreationType.BELOW);
        if (newDataType.isTopLevel()) {
            this.dataTypeList.insertBelow(newDataType, this.getDataType());
        } else {
            this.dataTypeList.refreshItemsByUpdatedDataTypes(updatedDataTypes);
        }
    }

    void insertNestedField() {
        this.closeEditMode();
        this.expand();
        List<DataType> updatedDataTypes = this.newDataType().create(this.getDataType(), CreationType.NESTED);
        this.dataTypeList.refreshItemsByUpdatedDataTypes(updatedDataTypes);
    }

    private DataType newDataType() {
        return this.dataTypeManager.fromNew().get();
    }

    public static interface View
    extends UberElemental<DataTypeListItem> {
        public void setDataType(DataType var1);

        public void toggleArrow(boolean var1);

        public void expand();

        public void collapse();

        public void showEditButton();

        public void showSaveButton();

        public void setupSelectComponent(DataTypeSelect var1);

        public void setupConstraintComponent(DataTypeConstraint var1);

        public void setupCollectionComponent(SmallSwitchComponent var1);

        public void showCollectionContainer();

        public void hideCollectionContainer();

        public void showCollectionYesLabel();

        public void hideCollectionYesLabel();

        public void showConstraintText();

        public void hideConstraintText();

        public boolean isCollapsed();

        public void hideDataTypeNameInput();

        public void setConstraint(String var1);

        public void showDataTypeNameInput();

        public void enableFocusMode();

        public void disableFocusMode();

        public String getName();

        public void setName(String var1);

        public void showConstraintContainer();

        public void hideConstraintContainer();
    }
}

