/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.json.client.JSONNumber;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;
import elemental2.dom.Element;
import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.Node;
import elemental2.dom.NodeList;
import java.util.List;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.HiddenHelper;
import org.kie.workbench.common.dmn.client.editors.types.common.JQuery;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeList;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListItem;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.ElementHelper;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.ListItemViewCssHelper;

@Templated
@ApplicationScoped
public class DataTypeListView
implements DataTypeList.View {
    @DataField(value="list-items")
    private final HTMLDivElement listItems;
    @DataField(value="collapsed-description")
    private final HTMLDivElement collapsedDescription;
    @DataField(value="expanded-description")
    private final HTMLDivElement expandedDescription;
    @DataField(value="view-more")
    private final HTMLAnchorElement viewMore;
    @DataField(value="view-less")
    private final HTMLAnchorElement viewLess;
    @DataField(value="add-button")
    private final HTMLButtonElement addButton;
    private DataTypeList presenter;

    @Inject
    public DataTypeListView(HTMLDivElement listItems, HTMLDivElement collapsedDescription, HTMLDivElement expandedDescription, HTMLAnchorElement viewMore, HTMLAnchorElement viewLess, HTMLButtonElement addButton) {
        this.listItems = listItems;
        this.collapsedDescription = collapsedDescription;
        this.expandedDescription = expandedDescription;
        this.viewMore = viewMore;
        this.viewLess = viewLess;
        this.addButton = addButton;
    }

    public void init(DataTypeList presenter) {
        this.presenter = presenter;
    }

    @PostConstruct
    public void setup() {
        this.collapseDescription();
    }

    @Override
    public void setupListItems(List<DataTypeListItem> listItems) {
        this.listItems.innerHTML = "";
        listItems.forEach(this::appendItem);
    }

    @Override
    public void addSubItems(DataType dataType, List<DataTypeListItem> listItems) {
        this.cleanSubTypes(dataType.getUUID());
        Element parent = this.getDataTypeRow(dataType);
        for (DataTypeListItem item : listItems) {
            HTMLElement itemElement = item.getElement();
            this.hideItemElementIfParentIsCollapsed(itemElement, parent);
            ElementHelper.insertAfter((Node)itemElement, (Node)parent);
            parent = itemElement;
        }
        this.showArrowIconIfDataTypeHasChildren(dataType);
    }

    @Override
    public void addSubItem(DataTypeListItem listItem) {
        this.listItems.appendChild((Node)listItem.getElement());
    }

    @EventHandler(value={"add-button"})
    public void onAddClick(ClickEvent e) {
        double scrollTop = this.listItems.scrollHeight;
        this.scrollTo(this.listItems, scrollTop);
        this.presenter.addDataType();
    }

    void hideItemElementIfParentIsCollapsed(HTMLElement itemElement, Element parent) {
        boolean isCollapsedParent = this.isCollapsed(parent.querySelector("[data-field=\"arrow-button\"]"));
        boolean isHiddenParent = HiddenHelper.isHidden(parent);
        if (isCollapsedParent || isHiddenParent) {
            HiddenHelper.hide((Element)itemElement);
        } else {
            HiddenHelper.show((Element)itemElement);
        }
    }

    void showArrowIconIfDataTypeHasChildren(DataType dataType) {
        if (this.hasChildren(dataType)) {
            HiddenHelper.show(this.getDataTypeRow(dataType).querySelector("[data-field=\"arrow-button\"]"));
        } else {
            HiddenHelper.hide(this.getDataTypeRow(dataType).querySelector("[data-field=\"arrow-button\"]"));
        }
    }

    private boolean hasChildren(DataType dataType) {
        return this.listItems.querySelectorAll((String)new StringBuilder().append((String)"[data-parent-row-uuid=\"").append((String)dataType.getUUID()).append((String)"\"]").toString()).length > 0.0;
    }

    @Override
    public void removeItem(DataType dataType) {
        this.cleanSubTypes(dataType.getUUID());
        Optional<Element> dataTypeRow = Optional.ofNullable(this.getDataTypeRow(dataType));
        dataTypeRow.ifPresent(ElementHelper::remove);
    }

    void cleanSubTypes(String uuid) {
        String selector = "[data-parent-row-uuid=\"" + uuid + "\"]";
        NodeList subDataTypeRows = this.listItems.querySelectorAll(selector);
        int i = 0;
        while ((double)i < subDataTypeRows.length) {
            Element item = (Element)subDataTypeRows.getAt(i);
            if (item != null && item.parentNode != null) {
                this.cleanSubTypes(item.getAttribute("data-row-uuid"));
                ElementHelper.remove((Node)item);
            }
            ++i;
        }
    }

    @Override
    public void insertBelow(DataTypeListItem listItem, DataType reference) {
        Element elementReference = this.getLastSubDataTypeElement(reference);
        ElementHelper.insertAfter((Node)listItem.getElement(), (Node)elementReference);
    }

    @Override
    public void insertAbove(DataTypeListItem listItem, DataType reference) {
        Element elementReference = this.getDataTypeRow(reference);
        ElementHelper.insertBefore((Node)listItem.getElement(), (Node)elementReference);
    }

    boolean isCollapsed(Element arrow) {
        return ListItemViewCssHelper.isRightArrow(arrow);
    }

    @EventHandler(value={"view-more"})
    public void onClickViewMore(ClickEvent event) {
        this.expandDescription();
    }

    @EventHandler(value={"view-less"})
    public void onClickViewLess(ClickEvent event) {
        this.collapseDescription();
    }

    private void appendItem(DataTypeListItem listItem) {
        this.listItems.appendChild((Node)listItem.getElement());
    }

    void expandDescription() {
        this.collapsedDescription.hidden = true;
        this.expandedDescription.hidden = false;
        this.viewLess.hidden = false;
        this.viewMore.hidden = true;
    }

    void collapseDescription() {
        this.collapsedDescription.hidden = false;
        this.expandedDescription.hidden = true;
        this.viewLess.hidden = true;
        this.viewMore.hidden = false;
    }

    Element getDataTypeRow(DataType dataType) {
        return this.listItems.querySelector("[data-row-uuid=\"" + dataType.getUUID() + "\"]");
    }

    Element getLastSubDataTypeElement(DataType reference) {
        return this.getLastSubDataTypeElement(this.getDataTypeRow(reference));
    }

    Element getLastSubDataTypeElement(Element element) {
        String parentUUID = element.getAttribute("data-row-uuid");
        String selector = "[data-parent-row-uuid=\"" + parentUUID + "\"]";
        NodeList nestedElements = this.listItems.querySelectorAll(selector);
        if (nestedElements.length == 0.0) {
            return element;
        }
        return this.getLastSubDataTypeElement((Element)nestedElements.getAt((int)nestedElements.length - 1));
    }

    void scrollTo(HTMLDivElement listItems, double scrollPosition) {
        JavaScriptObject scrollTopProperty = this.property("scrollTop", scrollPosition);
        int duration = 800;
        JQuery.$((Node)listItems).animate(scrollTopProperty, 800);
    }

    private JavaScriptObject property(String key, double value) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(key, (JSONValue)new JSONNumber(value));
        return jsonObject.getJavaScriptObject();
    }
}

