/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.common;

import com.google.gwt.event.dom.client.ChangeEvent;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLInputElement;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.SmallSwitchComponent;

@Dependent
@Templated
public class SmallSwitchComponentView
implements SmallSwitchComponent.View {
    @DataField(value="input-checkbox")
    private final HTMLInputElement inputCheckbox;
    @DataField(value="checkbox-text")
    private final HTMLElement checkboxText;
    private final TranslationService translationService;
    private SmallSwitchComponent presenter;

    @Inject
    public SmallSwitchComponentView(HTMLInputElement inputCheckbox, @Named(value="span") HTMLElement checkboxText, TranslationService translationService) {
        this.inputCheckbox = inputCheckbox;
        this.checkboxText = checkboxText;
        this.translationService = translationService;
    }

    public void init(SmallSwitchComponent presenter) {
        this.presenter = presenter;
    }

    @PostConstruct
    public void setup() {
        this.refreshCheckBoxText();
    }

    @EventHandler(value={"input-checkbox"})
    public void onInputCheckBoxChange(ChangeEvent e) {
        this.refreshCheckBoxText();
    }

    @Override
    public boolean getValue() {
        return this.isChecked();
    }

    @Override
    public void setValue(boolean value) {
        this.inputCheckbox.checked = value;
        this.refreshCheckBoxText();
    }

    void refreshCheckBoxText() {
        this.checkboxText.textContent = this.isChecked() ? this.yes() : this.no();
    }

    private String no() {
        return this.translationService.format("SmallSwitchComponentView.No", new Object[0]);
    }

    private String yes() {
        return this.translationService.format("SmallSwitchComponentView.Yes", new Object[0]);
    }

    private boolean isChecked() {
        return this.inputCheckbox.checked;
    }
}

