/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.messages;

import com.google.gwt.event.dom.client.ClickEvent;
import elemental2.dom.DomGlobal;
import elemental2.dom.Element;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.NodeList;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.client.editors.types.messages.DataTypeFlashMessages;

@Templated
@ApplicationScoped
public class DataTypeFlashMessagesView
implements DataTypeFlashMessages.View {
    static final String ERROR_CSS_CLASS = "kie-data-types-error-element";
    static final String WARNING_CSS_CLASS = "kie-data-types-warning-element";
    static final String OPENED_CONTAINER_CSS_CLASS = "opened";
    @DataField(value="error-container")
    private final HTMLDivElement errorContainer;
    @DataField(value="warning-container")
    private final HTMLDivElement warningContainer;
    @DataField(value="strong-error-message")
    private final HTMLElement strongErrorMessage;
    @DataField(value="regular-error-message")
    private final HTMLElement regularErrorMessage;
    @DataField(value="strong-warning-message")
    private final HTMLElement strongWarningMessage;
    @DataField(value="regular-warning-message")
    private final HTMLElement regularWarningMessage;
    @DataField(value="ok-warning-button")
    private final HTMLButtonElement okWarningButton;
    @DataField(value="cancel-warning-button")
    private final HTMLButtonElement cancelWarningButton;
    private DataTypeFlashMessages presenter;

    @Inject
    public DataTypeFlashMessagesView(HTMLDivElement errorContainer, HTMLDivElement warningContainer, @Named(value="strong") HTMLElement strongErrorMessage, @Named(value="span") HTMLElement regularErrorMessage, @Named(value="strong") HTMLElement strongWarningMessage, @Named(value="span") HTMLElement regularWarningMessage, HTMLButtonElement okWarningButton, HTMLButtonElement cancelWarningButton) {
        this.errorContainer = errorContainer;
        this.warningContainer = warningContainer;
        this.strongErrorMessage = strongErrorMessage;
        this.regularErrorMessage = regularErrorMessage;
        this.strongWarningMessage = strongWarningMessage;
        this.regularWarningMessage = regularWarningMessage;
        this.okWarningButton = okWarningButton;
        this.cancelWarningButton = cancelWarningButton;
    }

    public void init(DataTypeFlashMessages presenter) {
        this.presenter = presenter;
    }

    @EventHandler(value={"ok-warning-button"})
    public void onOkWarningButtonClick(ClickEvent e) {
        this.presenter.executeSuccessWarningCallback();
        this.hideWarningContainer();
        this.disableWarningHighlight();
    }

    @EventHandler(value={"cancel-warning-button"})
    public void onCancelWarningButtonClick(ClickEvent e) {
        this.presenter.executeErrorWarningCallback();
        this.hideWarningContainer();
        this.disableWarningHighlight();
    }

    @Override
    public void showErrorMessage(String strongMessage, String regularMessage) {
        this.show((Element)this.errorContainer);
        this.strongErrorMessage.textContent = strongMessage;
        this.regularErrorMessage.textContent = regularMessage;
    }

    @Override
    public void showWarningMessage(String strongMessage, String regularMessage) {
        this.show((Element)this.warningContainer);
        this.strongWarningMessage.textContent = strongMessage;
        this.regularWarningMessage.textContent = regularMessage;
    }

    @Override
    public void showErrorHighlight(String errorElementSelector) {
        Element element = this.getElement().parentNode.querySelector(errorElementSelector);
        this.enableErrorHighlight(element);
        this.setupDisableErrorHighlightCallbacks(element);
        element.focus();
    }

    @Override
    public void showWarningHighlight(String warningElementSelector) {
        this.disableWarningHighlight();
        Element element = this.getElement().parentNode.querySelector(warningElementSelector);
        this.enableWarningHighlight(element);
    }

    @Override
    public void hideWarningContainer() {
        this.hide((Element)this.warningContainer);
    }

    @Override
    public void hideErrorContainer() {
        this.hide((Element)this.errorContainer);
    }

    void setupDisableErrorHighlightCallbacks(Element element) {
        element.onkeypress = e -> {
            this.disableErrorHighlight(element);
            return true;
        };
        element.onblur = e -> {
            this.disableErrorHighlight(element);
            return true;
        };
    }

    void enableErrorHighlight(Element element) {
        element.classList.add(new String[]{ERROR_CSS_CLASS});
    }

    void enableWarningHighlight(Element element) {
        element.classList.add(new String[]{WARNING_CSS_CLASS});
    }

    void disableWarningHighlight() {
        NodeList warningElements = this.getElement().parentNode.querySelectorAll(".kie-data-types-warning-element");
        int i = 0;
        while ((double)i < warningElements.length) {
            ((Element)warningElements.getAt((int)i)).classList.remove(new String[]{WARNING_CSS_CLASS});
            ++i;
        }
    }

    void disableErrorHighlight(Element element) {
        element.classList.remove(new String[]{ERROR_CSS_CLASS});
        this.setTimeout(type -> {
            boolean isErrorEnabled = element.classList.contains(ERROR_CSS_CLASS);
            if (!isErrorEnabled) {
                this.hideErrorContainer();
                this.teardownDisableErrorHighlightCallbacks(element);
            }
        }, 500.0);
    }

    void teardownDisableErrorHighlightCallbacks(Element element) {
        element.onkeypress = e -> true;
        element.onblur = e -> true;
    }

    void setTimeout(DomGlobal.SetTimeoutCallbackFn callback, double delay) {
        DomGlobal.setTimeout((DomGlobal.SetTimeoutCallbackFn)callback, (double)delay, (Object[])new Object[0]);
    }

    private void hide(Element element) {
        element.classList.remove(new String[]{OPENED_CONTAINER_CSS_CLASS});
    }

    private void show(Element element) {
        element.classList.add(new String[]{OPENED_CONTAINER_CSS_CLASS});
    }
}

