/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.persistence.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.v1_1.Definitions;
import org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.persistence.ItemDefinitionStore;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;

@Dependent
public class ItemDefinitionDestroyHandler {
    private final ItemDefinitionStore itemDefinitionStore;
    private final DMNGraphUtils dmnGraphUtils;

    @Inject
    public ItemDefinitionDestroyHandler(ItemDefinitionStore itemDefinitionStore, DMNGraphUtils dmnGraphUtils) {
        this.itemDefinitionStore = itemDefinitionStore;
        this.dmnGraphUtils = dmnGraphUtils;
    }

    public void destroy(DataType dataType) {
        ItemDefinition itemDefinition = this.findItemDefinition(dataType);
        Optional<ItemDefinition> itemDefinitionParent = this.findItemDefinitionParent(dataType);
        itemDefinitionParent.ifPresent(parent -> parent.getItemComponent().remove(itemDefinition));
        this.itemDefinitions().remove(itemDefinition);
        this.itemDefinitionStore.unIndex(dataType.getUUID());
    }

    Optional<ItemDefinition> findItemDefinitionParent(DataType dataType) {
        Optional<ItemDefinition> itemDefinitionParent = Optional.ofNullable(this.itemDefinitionStore.get(dataType.getParentUUID()));
        if (itemDefinitionParent.isPresent()) {
            ItemDefinition parent = itemDefinitionParent.get();
            if (parent.getTypeRef() == null) {
                return Optional.of(parent);
            }
            for (ItemDefinition itemDefinition : this.itemDefinitions()) {
                if (!Objects.equals(itemDefinition.getName().getValue(), parent.getTypeRef().getLocalPart())) continue;
                return Optional.of(itemDefinition);
            }
        }
        return Optional.empty();
    }

    List<ItemDefinition> itemDefinitions() {
        Optional<Definitions> definitions = Optional.ofNullable(this.dmnGraphUtils.getDefinitions());
        if (definitions.isPresent()) {
            return definitions.get().getItemDefinition();
        }
        return new ArrayList<ItemDefinition>();
    }

    private ItemDefinition findItemDefinition(DataType dataType) {
        return this.itemDefinitionStore.get(dataType.getUUID());
    }
}

