/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.persistence.handlers;

import java.util.Objects;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition;
import org.kie.workbench.common.dmn.api.definition.v1_1.UnaryTests;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManager;
import org.kie.workbench.common.dmn.client.editors.types.common.ItemDefinitionUtils;
import org.kie.workbench.common.stunner.core.util.StringUtils;

@Dependent
public class ItemDefinitionUpdateHandler {
    private final DataTypeManager dataTypeManager;
    private final ItemDefinitionUtils itemDefinitionUtils;

    @Inject
    public ItemDefinitionUpdateHandler(DataTypeManager dataTypeManager, ItemDefinitionUtils itemDefinitionUtils) {
        this.dataTypeManager = dataTypeManager;
        this.itemDefinitionUtils = itemDefinitionUtils;
    }

    public void update(DataType dataType, ItemDefinition itemDefinition) {
        if (this.isStructure(dataType)) {
            itemDefinition.setTypeRef(null);
        } else {
            itemDefinition.setTypeRef(this.makeQName(dataType));
            itemDefinition.getItemComponent().clear();
        }
        itemDefinition.setIsCollection(Boolean.valueOf(dataType.isCollection()));
        itemDefinition.setName(this.makeName(dataType));
        itemDefinition.setAllowedValues(this.makeAllowedValues(dataType, itemDefinition));
    }

    UnaryTests makeAllowedValues(DataType dataType, ItemDefinition itemDefinition) {
        String constraint = dataType.getConstraint();
        if (StringUtils.isEmpty((String)constraint)) {
            return null;
        }
        if (!Objects.equals(constraint, this.getText(itemDefinition))) {
            return new UnaryTests(new Id(), new Description(), new Text(constraint), null);
        }
        return itemDefinition.getAllowedValues();
    }

    String getText(ItemDefinition itemDefinition) {
        return this.itemDefinitionUtils.getConstraintText(itemDefinition);
    }

    Name makeName(DataType dataType) {
        return new Name(dataType.getName());
    }

    QName makeQName(DataType dataType) {
        return this.normaliseTypeRef(new QName("", dataType.getType()));
    }

    QName normaliseTypeRef(QName typeRef) {
        return this.itemDefinitionUtils.normaliseTypeRef(typeRef);
    }

    private boolean isStructure(DataType dataType) {
        return Objects.equals(dataType.getType(), this.dataTypeManager.structure());
    }
}

