/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.graph;

import java.util.Optional;
import java.util.stream.StreamSupport;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNDiagram;
import org.kie.workbench.common.dmn.api.definition.v1_1.Definitions;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;

@Dependent
public class DMNGraphUtils {
    private SessionManager sessionManager;

    public DMNGraphUtils() {
    }

    @Inject
    public DMNGraphUtils(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public Definitions getDefinitions() {
        ClientSession session = this.sessionManager.getCurrentSession();
        if (session == null) {
            return null;
        }
        CanvasHandler canvasHandler = session.getCanvasHandler();
        if (canvasHandler == null) {
            return null;
        }
        Graph graph = canvasHandler.getDiagram().getGraph();
        Optional<DMNDiagram> diagram = StreamSupport.stream(graph.nodes().spliterator(), false).map(Element::getContent).filter(c -> c instanceof Definition).map(c -> (Definition)c).map(Definition::getDefinition).filter(d -> d instanceof DMNDiagram).map(d -> (DMNDiagram)d).findFirst();
        return diagram.isPresent() ? diagram.get().getDefinitions() : null;
    }
}

