/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid;

import com.ait.lienzo.client.core.event.INodeXYEvent;
import com.ait.lienzo.client.core.event.NodeMouseDoubleClickHandler;
import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.enterprise.event.Event;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.HasTypeRef;
import org.kie.workbench.common.dmn.api.definition.NOPDomainObject;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.commands.general.DeleteCellValueCommand;
import org.kie.workbench.common.dmn.client.commands.general.DeleteHasNameCommand;
import org.kie.workbench.common.dmn.client.commands.general.DeleteHeaderValueCommand;
import org.kie.workbench.common.dmn.client.commands.general.SetCellValueCommand;
import org.kie.workbench.common.dmn.client.commands.general.SetHasNameCommand;
import org.kie.workbench.common.dmn.client.commands.general.SetHeaderValueCommand;
import org.kie.workbench.common.dmn.client.commands.general.SetTypeRefCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.widgets.grid.ExpressionGridCache;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.EditableHeaderGridWidgetMouseDoubleClickHandler;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.EditableHeaderMetaData;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.factory.TextAreaSingletonDOMElementFactory;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.factory.TextBoxSingletonDOMElementFactory;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.BaseUIModelMapper;
import org.kie.workbench.common.dmn.client.widgets.grid.model.ExpressionEditorChanged;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellValueTuple;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommand;
import org.kie.workbench.common.stunner.core.domainobject.DomainObject;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.util.CoordinateUtilities;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.BaseGridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLayerRedrawManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.GridPinnedModeManager;

public abstract class BaseExpressionGrid<E extends Expression, D extends GridData, M extends BaseUIModelMapper<E>>
extends BaseGridWidget
implements ExpressionGridCache.IsCacheable {
    public static final double DEFAULT_PADDING = 10.0;
    public static final Function<BaseExpressionGrid, Double> RESIZE_EXISTING = beg -> beg.getWidth() + beg.getPadding() * 2.0;
    public static final Function<BaseExpressionGrid, Double> RESIZE_EXISTING_MINIMUM = beg -> beg.getMinimumWidth() + beg.getPadding() * 2.0;
    protected final GridCellTuple parent;
    protected final Optional<String> nodeUUID;
    protected final HasExpression hasExpression;
    protected final Optional<E> expression;
    protected final Optional<HasName> hasName;
    protected final DMNGridPanel gridPanel;
    protected final DMNGridLayer gridLayer;
    protected final DefinitionUtils definitionUtils;
    protected final SessionManager sessionManager;
    protected final SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    protected final CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory;
    protected final CellEditorControlsView.Presenter cellEditorControls;
    protected final ListSelectorView.Presenter listSelector;
    protected final TranslationService translationService;
    protected final Event<ExpressionEditorChanged> editorSelectedEvent;
    protected final Event<DomainObjectSelectionEvent> domainObjectSelectionEvent;
    protected Optional<DomainObject> selectedDomainObject = Optional.empty();
    protected final int nesting;
    protected M uiModelMapper;

    public BaseExpressionGrid(GridCellTuple parent, Optional<String> nodeUUID, HasExpression hasExpression, Optional<E> expression, Optional<HasName> hasName, DMNGridPanel gridPanel, DMNGridLayer gridLayer, D gridData, GridRenderer gridRenderer, DefinitionUtils definitionUtils, SessionManager sessionManager, SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory, Event<ExpressionEditorChanged> editorSelectedEvent, Event<DomainObjectSelectionEvent> domainObjectSelectionEvent, CellEditorControlsView.Presenter cellEditorControls, ListSelectorView.Presenter listSelector, TranslationService translationService, int nesting) {
        super(gridData, (GridSelectionManager)gridLayer, (GridPinnedModeManager)gridLayer, gridRenderer);
        this.parent = parent;
        this.nodeUUID = nodeUUID;
        this.gridPanel = gridPanel;
        this.gridLayer = gridLayer;
        this.definitionUtils = definitionUtils;
        this.sessionManager = sessionManager;
        this.sessionCommandManager = sessionCommandManager;
        this.canvasCommandFactory = canvasCommandFactory;
        this.editorSelectedEvent = editorSelectedEvent;
        this.domainObjectSelectionEvent = domainObjectSelectionEvent;
        this.cellEditorControls = cellEditorControls;
        this.listSelector = listSelector;
        this.translationService = translationService;
        this.hasExpression = hasExpression;
        this.expression = expression;
        this.hasName = hasName;
        this.nesting = nesting;
        this.doInitialisation();
    }

    protected void doInitialisation() {
        this.uiModelMapper = this.makeUiModelMapper();
        this.initialiseUiColumns();
        this.initialiseUiModel();
    }

    protected abstract M makeUiModelMapper();

    protected abstract void initialiseUiColumns();

    protected abstract void initialiseUiModel();

    protected abstract boolean isHeaderHidden();

    public Consumer<HasName> clearDisplayNameConsumer(boolean updateStunnerTitle) {
        return hn -> {
            CompositeCommand.Builder commandBuilder = this.newHasNameHasNoValueCommand((HasName)hn);
            if (updateStunnerTitle) {
                this.getUpdateStunnerTitleCommand("").ifPresent(arg_0 -> ((CompositeCommand.Builder)commandBuilder).addCommand(arg_0));
            }
            this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (Command)commandBuilder.build());
        };
    }

    public BiConsumer<HasName, Name> setDisplayNameConsumer(boolean updateStunnerTitle) {
        return (hn, name) -> {
            CompositeCommand.Builder commandBuilder = this.newHasNameHasValueCommand((HasName)hn, (Name)name);
            if (updateStunnerTitle) {
                this.getUpdateStunnerTitleCommand(name.getValue()).ifPresent(arg_0 -> ((CompositeCommand.Builder)commandBuilder).addCommand(arg_0));
            }
            this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (Command)commandBuilder.build());
        };
    }

    public BiConsumer<HasTypeRef, QName> setTypeRefConsumer() {
        return (htr, typeRef) -> this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (Command)new SetTypeRefCommand((HasTypeRef)htr, (QName)typeRef, () -> {
            this.gridLayer.batch();
            this.selectedDomainObject.ifPresent(this::fireDomainObjectSelectionEvent);
        }));
    }

    protected CompositeCommand.Builder newHasNameHasNoValueCommand(HasName hasName) {
        CompositeCommand.Builder commandBuilder = new CompositeCommand.Builder();
        commandBuilder.addCommand((Command)new DeleteHasNameCommand(hasName, () -> {
            this.gridLayer.batch();
            this.selectedDomainObject.ifPresent(this::fireDomainObjectSelectionEvent);
        }));
        return commandBuilder;
    }

    protected CompositeCommand.Builder newHasNameHasValueCommand(HasName hasName, Name name) {
        CompositeCommand.Builder commandBuilder = new CompositeCommand.Builder();
        commandBuilder.addCommand((Command)new SetHasNameCommand(hasName, name, () -> {
            this.gridLayer.batch();
            this.selectedDomainObject.ifPresent(this::fireDomainObjectSelectionEvent);
        }));
        return commandBuilder;
    }

    protected Optional<AbstractCanvasGraphCommand> getUpdateStunnerTitleCommand(String value) {
        AbstractCanvasGraphCommand command = null;
        if (this.getNodeUUID().isPresent()) {
            Definition definition;
            String nameId;
            String uuid = this.getNodeUUID().get();
            AbstractCanvasHandler canvasHandler = (AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler();
            Element element = canvasHandler.getGraphIndex().get(uuid);
            if (element.getContent() instanceof Definition && (nameId = this.definitionUtils.getNameIdentifier((definition = (Definition)element.getContent()).getDefinition())) != null) {
                command = (AbstractCanvasGraphCommand)this.canvasCommandFactory.updatePropertyValue(element, nameId, (Object)value);
            }
        }
        return Optional.ofNullable(command);
    }

    public TextAreaSingletonDOMElementFactory getBodyTextAreaFactory() {
        return new TextAreaSingletonDOMElementFactory(this.gridPanel, (GridLayer)this.gridLayer, (GridWidget)this, this.sessionManager, this.sessionCommandManager, this.newCellHasNoValueCommand(), this.newCellHasValueCommand());
    }

    public TextBoxSingletonDOMElementFactory getBodyTextBoxFactory() {
        return new TextBoxSingletonDOMElementFactory(this.gridPanel, (GridLayer)this.gridLayer, (GridWidget)this, this.sessionManager, this.sessionCommandManager, this.newCellHasNoValueCommand(), this.newCellHasValueCommand());
    }

    protected Function<GridCellTuple, Command> newCellHasNoValueCommand() {
        return gridCellTuple -> new DeleteCellValueCommand((GridCellTuple)gridCellTuple, () -> this.uiModelMapper, this.gridLayer::batch);
    }

    protected Function<GridCellValueTuple, Command> newCellHasValueCommand() {
        return gridCellValueTuple -> new SetCellValueCommand((GridCellValueTuple)gridCellValueTuple, () -> this.uiModelMapper, this.gridLayer::batch);
    }

    public TextAreaSingletonDOMElementFactory getHeaderTextAreaFactory() {
        return new TextAreaSingletonDOMElementFactory(this.gridPanel, (GridLayer)this.gridLayer, (GridWidget)this, this.sessionManager, this.sessionCommandManager, this.newHeaderHasNoValueCommand(), this.newHeaderHasValueCommand());
    }

    protected Function<GridCellTuple, Command> newHeaderHasNoValueCommand() {
        return gc -> new DeleteHeaderValueCommand(this.extractEditableHeaderMetaData((GridCellTuple)gc), this.gridLayer::batch);
    }

    protected Function<GridCellValueTuple, Command> newHeaderHasValueCommand() {
        return gcv -> {
            String title = gcv.getValue().getValue().toString();
            return new SetHeaderValueCommand(title, this.extractEditableHeaderMetaData((GridCellTuple)gcv), this.gridLayer::batch);
        };
    }

    protected EditableHeaderMetaData extractEditableHeaderMetaData(GridCellTuple gc) {
        int headerRowIndex = gc.getRowIndex();
        int headerColumnIndex = gc.getColumnIndex();
        GridColumn.HeaderMetaData headerMetaData = (GridColumn.HeaderMetaData)((GridColumn)((BaseUIModelMapper)this.uiModelMapper).getUiModel().get().getColumns().get(headerColumnIndex)).getHeaderMetaData().get(headerRowIndex);
        if (headerMetaData instanceof EditableHeaderMetaData) {
            return (EditableHeaderMetaData)headerMetaData;
        }
        throw new IllegalArgumentException("Header (" + headerColumnIndex + ", " + headerRowIndex + ") was not an instanceof EditableHeaderMetaData");
    }

    protected NodeMouseDoubleClickHandler getGridMouseDoubleClickHandler(GridSelectionManager selectionManager, GridPinnedModeManager pinnedModeManager) {
        return new EditableHeaderGridWidgetMouseDoubleClickHandler((GridWidget)this, selectionManager, pinnedModeManager, this.renderer);
    }

    public boolean onDragHandle(INodeXYEvent event) {
        return false;
    }

    public Viewport getViewport() {
        Viewport viewport = super.getViewport();
        if (viewport == null) {
            viewport = this.gridLayer.getViewport();
        }
        return viewport;
    }

    public Layer getLayer() {
        Object layer = super.getLayer();
        if (layer == null) {
            layer = this.gridLayer;
        }
        return layer;
    }

    public void select() {
        this.fireExpressionEditorChanged();
        super.select();
    }

    private void fireExpressionEditorChanged() {
        this.editorSelectedEvent.fire((Object)new ExpressionEditorChanged());
    }

    public void deselect() {
        this.fireExpressionEditorChanged();
        this.getModel().clearSelections();
        this.clearSelectedDomainObject();
        super.deselect();
    }

    void clearSelectedDomainObject() {
        this.selectedDomainObject = Optional.empty();
    }

    protected void executeRenderQueueCommands(boolean isSelectionLayer) {
        ArrayList<Pair> gridLineCommands = new ArrayList<Pair>();
        ArrayList<Pair> allOtherCommands = new ArrayList<Pair>();
        ArrayList<Pair> selectedCellsCommands = new ArrayList<Pair>();
        for (Map.Entry p2 : this.renderQueue) {
            Group parent = (Group)p2.getKey();
            List commands = (List)p2.getValue();
            for (GridRenderer.RendererCommand command : commands) {
                if (command instanceof GridRenderer.RenderSelectedCellsCommand) {
                    selectedCellsCommands.add(new Pair((Object)parent, (Object)command));
                    continue;
                }
                if (command instanceof GridRenderer.RenderHeaderGridLinesCommand) {
                    gridLineCommands.add(new Pair((Object)parent, (Object)command));
                    continue;
                }
                if (command instanceof GridRenderer.RenderBodyGridLinesCommand) {
                    gridLineCommands.add(new Pair((Object)parent, (Object)command));
                    continue;
                }
                allOtherCommands.add(new Pair((Object)parent, (Object)command));
            }
        }
        Predicate<Pair> renderHeader = p -> {
            GridRenderer.RendererCommand command = (GridRenderer.RendererCommand)p.getK2();
            if (this.isHeaderHidden()) {
                return !(command instanceof GridRenderer.RendererHeaderCommand);
            }
            return true;
        };
        this.renderQueue.clear();
        allOtherCommands.stream().filter(renderHeader).forEach(p -> this.addCommandToRenderQueue((Group)p.getK1(), (GridRenderer.RendererCommand)p.getK2()));
        gridLineCommands.stream().filter(renderHeader).forEach(p -> this.addCommandToRenderQueue((Group)p.getK1(), (GridRenderer.RendererCommand)p.getK2()));
        selectedCellsCommands.stream().filter(renderHeader).forEach(p -> this.addCommandToRenderQueue((Group)p.getK1(), (GridRenderer.RendererCommand)p.getK2()));
        super.executeRenderQueueCommands(isSelectionLayer);
    }

    public Optional<E> getExpression() {
        return this.expression;
    }

    public double getPadding() {
        return 10.0;
    }

    public GridCellTuple getParentInformation() {
        return this.parent;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    Optional<String> getNodeUUID() {
        return this.nodeUUID;
    }

    public double getMinimumWidth() {
        double minimumWidth = 0.0;
        int columnCount = this.model.getColumnCount();
        List uiColumns = this.model.getColumns();
        for (int columnIndex = 0; columnIndex < columnCount - 1; ++columnIndex) {
            GridColumn editorColumn = (GridColumn)uiColumns.get(columnIndex);
            minimumWidth += editorColumn.getWidth();
        }
        if (columnCount > 0) {
            minimumWidth += ((GridColumn)uiColumns.get(columnCount - 1)).getMinimumWidth().doubleValue();
        }
        return minimumWidth;
    }

    public void resize(Function<BaseExpressionGrid, Double> requiredWidthSupplier) {
        this.doResize(new GridLayerRedrawManager.PrioritizedCommand(0){

            public void execute() {
                BaseExpressionGrid.this.gridLayer.draw();
            }
        }, requiredWidthSupplier);
    }

    protected void doResize(GridLayerRedrawManager.PrioritizedCommand command, Function<BaseExpressionGrid, Double> requiredWidthSupplier) {
        double proposedWidth = this.getWidth() + this.getPadding() * 2.0;
        this.parent.proposeContainingColumnWidth(proposedWidth, requiredWidthSupplier);
        this.gridPanel.refreshScrollPosition();
        this.gridPanel.updatePanelSize();
        this.parent.onResize();
        this.gridLayer.batch(command);
    }

    public void selectFirstCell() {
        GridData uiModel = this.getModel();
        if (uiModel.getRowCount() == 0 || uiModel.getColumnCount() == 0) {
            return;
        }
        uiModel.clearSelections();
        uiModel.getColumns().stream().filter(c -> !(c instanceof RowNumberColumn)).map(c -> uiModel.getColumns().indexOf(c)).findFirst().ifPresent(index -> this.selectCell(0, (int)index, false, false));
    }

    public boolean selectCell(Point2D ap, boolean isShiftKeyDown, boolean isControlKeyDown) {
        Integer uiRowIndex = CoordinateUtilities.getUiRowIndex((GridWidget)this, (double)ap.getY());
        Integer uiColumnIndex = CoordinateUtilities.getUiColumnIndex((GridWidget)this, (double)ap.getX());
        if (uiRowIndex == null || uiColumnIndex == null) {
            return false;
        }
        this.gridLayer.select((GridWidget)this);
        boolean isSelectionChanged = super.selectCell(uiRowIndex.intValue(), uiColumnIndex.intValue(), isShiftKeyDown, isControlKeyDown);
        if (isSelectionChanged) {
            this.doAfterSelectionChange(uiRowIndex, uiColumnIndex);
        }
        return isSelectionChanged;
    }

    public boolean selectCell(int uiRowIndex, int uiColumnIndex, boolean isShiftKeyDown, boolean isControlKeyDown) {
        this.gridLayer.select((GridWidget)this);
        boolean isSelectionChanged = super.selectCell(uiRowIndex, uiColumnIndex, isShiftKeyDown, isControlKeyDown);
        if (isSelectionChanged) {
            this.doAfterSelectionChange(uiRowIndex, uiColumnIndex);
        }
        return isSelectionChanged;
    }

    public boolean selectHeaderCell(Point2D ap, boolean isShiftKeyDown, boolean isControlKeyDown) {
        Integer uiHeaderRowIndex = CoordinateUtilities.getUiHeaderRowIndex((GridWidget)this, (Point2D)ap);
        Integer uiHeaderColumnIndex = CoordinateUtilities.getUiColumnIndex((GridWidget)this, (double)ap.getX());
        if (uiHeaderRowIndex == null || uiHeaderColumnIndex == null) {
            return false;
        }
        boolean isSelectionChanged = super.selectHeaderCell(uiHeaderRowIndex.intValue(), uiHeaderColumnIndex.intValue(), isShiftKeyDown, isControlKeyDown);
        if (isSelectionChanged) {
            this.doAfterHeaderSelectionChange(uiHeaderRowIndex, uiHeaderColumnIndex);
        }
        return isSelectionChanged;
    }

    public boolean selectHeaderCell(int uiHeaderRowIndex, int uiHeaderColumnIndex, boolean isShiftKeyDown, boolean isControlKeyDown) {
        boolean isSelectionChanged = super.selectHeaderCell(uiHeaderRowIndex, uiHeaderColumnIndex, isShiftKeyDown, isControlKeyDown);
        if (isSelectionChanged) {
            this.doAfterHeaderSelectionChange(uiHeaderRowIndex, uiHeaderColumnIndex);
        }
        return isSelectionChanged;
    }

    protected boolean hasAnyHeaderCellSelected() {
        return this.getModel().getSelectedHeaderCells().size() > 0;
    }

    protected boolean hasMultipleCellsSelected() {
        return this.getModel().getSelectedCells().size() > 1;
    }

    protected void doAfterSelectionChange(int uiRowIndex, int uiColumnIndex) {
        this.fireDomainObjectSelectionEvent((DomainObject)new NOPDomainObject());
    }

    protected void doAfterHeaderSelectionChange(int uiHeaderRowIndex, int uiHeaderColumnIndex) {
        this.fireDomainObjectSelectionEvent((DomainObject)new NOPDomainObject());
    }

    public void selectExpressionEditorFirstCell(int uiRowIndex, int uiColumnIndex) {
        GridCellValue value = this.model.getCell(uiRowIndex, uiColumnIndex).getValue();
        Optional grid = (Optional)((ExpressionCellValue)value).getValue();
        grid.ifPresent(beg -> {
            ((DMNGridLayer)this.getLayer()).select((GridWidget)beg);
            beg.selectFirstCell();
        });
    }

    public Optional<BaseExpressionGrid> findParentGrid() {
        GridWidget gridWidget = this.parent.getGridWidget();
        if (gridWidget instanceof BaseExpressionGrid) {
            return Optional.of((BaseExpressionGrid)gridWidget);
        }
        return Optional.empty();
    }

    protected void fireDomainObjectSelectionEvent(DomainObject domainObject) {
        CanvasHandler canvasHandler;
        ClientSession session = this.sessionManager.getCurrentSession();
        if (session != null && (canvasHandler = session.getCanvasHandler()) != null) {
            this.domainObjectSelectionEvent.fire((Object)new DomainObjectSelectionEvent(canvasHandler, domainObject));
            this.selectedDomainObject = Optional.of(domainObject);
        }
    }
}

