/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.columns;

import com.ait.lienzo.client.core.event.NodeMouseDoubleClickEvent;
import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.types.Point2D;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.EditableHeaderMetaData;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.EditableHeaderUtilities;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.util.CoordinateUtilities;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellEditContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.BaseGridWidgetMouseDoubleClickHandler;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.GridPinnedModeManager;

public class EditableHeaderGridWidgetMouseDoubleClickHandler
extends BaseGridWidgetMouseDoubleClickHandler {
    public EditableHeaderGridWidgetMouseDoubleClickHandler(GridWidget gridWidget, GridSelectionManager selectionManager, GridPinnedModeManager pinnedModeManager, GridRenderer renderer) {
        super(gridWidget, selectionManager, pinnedModeManager, renderer);
    }

    protected boolean handleHeaderCellDoubleClick(NodeMouseDoubleClickEvent event) {
        double headerMaxY;
        Point2D rp = CoordinateUtilities.convertDOMToGridCoordinate((GridWidget)this.gridWidget, (Point2D)new Point2D((double)event.getX(), (double)event.getY()));
        double cx = rp.getX();
        double cy = rp.getY();
        Group header = this.gridWidget.getHeader();
        BaseGridRendererHelper rendererHelper = this.gridWidget.getRendererHelper();
        BaseGridRendererHelper.RenderingInformation ri = rendererHelper.getRenderingInformation();
        double headerRowsYOffset = ri.getHeaderRowsYOffset();
        double headerMinY = header == null ? headerRowsYOffset : header.getY() + headerRowsYOffset;
        double d = headerMaxY = header == null ? this.renderer.getHeaderHeight() : this.renderer.getHeaderHeight() + header.getY();
        if (cx < 0.0 || cx > this.gridWidget.getWidth()) {
            return false;
        }
        if (cy < headerMinY || cy > headerMaxY) {
            return false;
        }
        BaseGridRendererHelper.ColumnInformation ci = rendererHelper.getColumnInformation(cx);
        GridColumn column = ci.getColumn();
        if (column == null) {
            return false;
        }
        if (!EditableHeaderUtilities.hasEditableHeader(column)) {
            return false;
        }
        Integer uiHeaderRowIndex = CoordinateUtilities.getUiHeaderRowIndex((GridWidget)this.gridWidget, (Point2D)rp);
        if (uiHeaderRowIndex == null) {
            return false;
        }
        if (!EditableHeaderUtilities.isEditableHeader(column, uiHeaderRowIndex)) {
            return false;
        }
        Point2D gridWidgetComputedLocation = this.gridWidget.getComputedLocation();
        EditableHeaderMetaData headerMetaData = (EditableHeaderMetaData)column.getHeaderMetaData().get(uiHeaderRowIndex);
        GridBodyCellEditContext context = EditableHeaderUtilities.makeRenderContext(this.gridWidget, ri, ci, rp.add(gridWidgetComputedLocation), uiHeaderRowIndex);
        headerMetaData.edit(context);
        return true;
    }
}

