/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.columns;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.HasTypeRef;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.InformationItemCell;
import org.kie.workbench.common.dmn.client.editors.types.HasNameAndTypeRef;
import org.kie.workbench.common.dmn.client.editors.types.NameAndDataTypePopoverView;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.NameAndDataTypeColumnRenderer;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNSimpleGridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellEditContext;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;

public abstract class EditableNameAndDataTypeColumn<G extends BaseExpressionGrid>
extends DMNSimpleGridColumn<G, InformationItemCell.HasNameCell> {
    private final Predicate<Integer> isEditable;
    private final Consumer<HasName> clearDisplayNameConsumer;
    private final BiConsumer<HasName, Name> setDisplayNameConsumer;
    private final BiConsumer<HasTypeRef, QName> setTypeRefConsumer;
    private final CellEditorControlsView.Presenter cellEditorControls;
    private final NameAndDataTypePopoverView.Presenter editor;
    private final Optional<String> editorTitle;

    public EditableNameAndDataTypeColumn(GridColumn.HeaderMetaData headerMetaData, G gridWidget, Predicate<Integer> isEditable, Consumer<HasName> clearDisplayNameConsumer, BiConsumer<HasName, Name> setDisplayNameConsumer, BiConsumer<HasTypeRef, QName> setTypeRefConsumer, CellEditorControlsView.Presenter cellEditorControls, NameAndDataTypePopoverView.Presenter editor, Optional<String> editorTitle) {
        this(Collections.singletonList(headerMetaData), gridWidget, isEditable, clearDisplayNameConsumer, setDisplayNameConsumer, setTypeRefConsumer, cellEditorControls, editor, editorTitle);
    }

    public EditableNameAndDataTypeColumn(List<GridColumn.HeaderMetaData> headerMetaData, G gridWidget, Predicate<Integer> isEditable, Consumer<HasName> clearDisplayNameConsumer, BiConsumer<HasName, Name> setDisplayNameConsumer, BiConsumer<HasTypeRef, QName> setTypeRefConsumer, CellEditorControlsView.Presenter cellEditorControls, NameAndDataTypePopoverView.Presenter editor, Optional<String> editorTitle) {
        super(headerMetaData, new NameAndDataTypeColumnRenderer(), gridWidget);
        this.isEditable = isEditable;
        this.clearDisplayNameConsumer = clearDisplayNameConsumer;
        this.setDisplayNameConsumer = setDisplayNameConsumer;
        this.setTypeRefConsumer = setTypeRefConsumer;
        this.cellEditorControls = cellEditorControls;
        this.editor = editor;
        this.editorTitle = editorTitle;
        this.setMovable(false);
        this.setResizable(true);
    }

    public void edit(GridCell<InformationItemCell.HasNameCell> cell, GridBodyCellRenderContext context, Consumer<GridCellValue<InformationItemCell.HasNameCell>> callback) {
        int rowIndex = context.getRowIndex();
        if (!this.isEditable.test(rowIndex)) {
            return;
        }
        int uiRowIndex = context.getRowIndex();
        int uiColumnIndex = context.getColumnIndex();
        double cellWidth = context.getCellWidth();
        double cellHeight = context.getCellHeight();
        double absoluteCellX = context.getAbsoluteCellX();
        double absoluteCellY = context.getAbsoluteCellY();
        final InformationItemCell.HasNameAndDataTypeCell binding = (InformationItemCell.HasNameAndDataTypeCell)cell.getValue().getValue();
        this.editor.bind(new HasNameAndTypeRef(){

            public QName getTypeRef() {
                return binding.getTypeRef();
            }

            public void setTypeRef(QName typeRef) {
                if (Objects.equals(typeRef, this.getTypeRef())) {
                    return;
                }
                EditableNameAndDataTypeColumn.this.setTypeRefConsumer.accept(binding, typeRef);
            }

            public Name getName() {
                return binding.getName();
            }

            public void setName(Name name) {
                if (Objects.equals(name, this.getName())) {
                    return;
                }
                if (name == null || name.getValue() == null || name.getValue().trim().isEmpty()) {
                    EditableNameAndDataTypeColumn.this.clearDisplayNameConsumer.accept(binding);
                } else {
                    EditableNameAndDataTypeColumn.this.setDisplayNameConsumer.accept(binding, name);
                }
            }

            public DMNModelInstrumentedBase asDMNModelInstrumentedBase() {
                return binding.asDMNModelInstrumentedBase();
            }
        }, uiRowIndex, uiColumnIndex);
        double[] dxy = new double[]{absoluteCellX + cellWidth / 2.0, absoluteCellY + cellHeight / 2.0};
        Optional rx = ((GridBodyCellEditContext)context).getRelativeLocation();
        rx.ifPresent(r -> {
            dxy[0] = r.getX();
            dxy[1] = r.getY();
        });
        this.cellEditorControls.show(this.editor, this.editorTitle, (int)dxy[0], (int)dxy[1]);
    }

    @Override
    protected GridCellValue<InformationItemCell.HasNameCell> makeDefaultCellValue() {
        return new BaseGridCellValue((Object)InformationItemCell.HasNameCell.wrap(""));
    }

    public void setWidth(double width) {
        super.setWidth(width);
        this.updateWidthOfPeers();
    }
}

