/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.model;

import java.util.List;
import org.kie.soup.commons.util.Lists;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.EditableHeaderMetaData;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.EditableHeaderUtilities;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridColumn;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellEditContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.columns.GridColumnRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;

public abstract class DMNGridColumn<G extends GridWidget, T>
extends BaseGridColumn<T> {
    public static final double DEFAULT_WIDTH = 100.0;
    protected final G gridWidget;

    public DMNGridColumn(GridColumn.HeaderMetaData headerMetaData, GridColumnRenderer<T> columnRenderer, G gridWidget) {
        this(new Lists.Builder().add((Object)headerMetaData).build(), columnRenderer, gridWidget);
    }

    public DMNGridColumn(List<GridColumn.HeaderMetaData> headerMetaData, GridColumnRenderer<T> columnRenderer, G gridWidget) {
        super(headerMetaData, columnRenderer, 100.0);
        this.gridWidget = gridWidget;
    }

    public void setWidthInternal(double width) {
        super.setWidth(width);
    }

    public void updateWidthOfPeers() {
        if (this.gridWidget instanceof BaseExpressionGrid) {
            BaseExpressionGrid beg = (BaseExpressionGrid)this.gridWidget;
            int parentColumnIndex = beg.getParentInformation().getColumnIndex();
            GridData parentGridData = beg.getParentInformation().getGridWidget().getModel();
            if (parentGridData != null && parentColumnIndex < parentGridData.getColumnCount()) {
                GridColumn parentColumn = (GridColumn)parentGridData.getColumns().get(parentColumnIndex);
                parentColumn.setWidth(beg.getWidth() + beg.getPadding() * 2.0);
            }
        }
    }

    public void startEditingHeaderCell(int uiHeaderRowIndex) {
        if (!EditableHeaderUtilities.hasEditableHeader(this)) {
            return;
        }
        if (!EditableHeaderUtilities.isEditableHeader(this, uiHeaderRowIndex)) {
            return;
        }
        BaseGridRendererHelper rendererHelper = this.gridWidget.getRendererHelper();
        BaseGridRendererHelper.RenderingInformation ri = rendererHelper.getRenderingInformation();
        double columnXCoordinate = rendererHelper.getColumnOffset((GridColumn)this) + this.getWidth() / 2.0;
        BaseGridRendererHelper.ColumnInformation ci = rendererHelper.getColumnInformation(columnXCoordinate);
        EditableHeaderMetaData headerMetaData = (EditableHeaderMetaData)this.getHeaderMetaData().get(uiHeaderRowIndex);
        GridBodyCellEditContext context = EditableHeaderUtilities.makeRenderContext(this.gridWidget, ri, ci, uiHeaderRowIndex);
        headerMetaData.edit(context);
    }
}

