/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.api.included.legacy;

import elemental2.dom.DomGlobal;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedModelsService;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedNode;

@Dependent
public class DMNIncludeModelsClient {
    private final Caller<DMNIncludedModelsService> service;
    private final WorkspaceProjectContext projectContext;

    @Inject
    public DMNIncludeModelsClient(Caller<DMNIncludedModelsService> service, WorkspaceProjectContext projectContext) {
        this.service = service;
        this.projectContext = projectContext;
    }

    public void loadModels(Consumer<List<DMNIncludedModel>> listConsumer) {
        ((DMNIncludedModelsService)this.service.call(this.onSuccess(listConsumer), this.onError(listConsumer))).loadModels(this.getWorkspaceProject());
    }

    public void loadNodesFromImports(List<DMNIncludedModel> includeModels, Consumer<List<DMNIncludedNode>> listConsumer) {
        ((DMNIncludedModelsService)this.service.call(this.onSuccess(listConsumer), this.onError(listConsumer))).loadNodesFromImports(this.getWorkspaceProject(), includeModels);
    }

    public void loadItemDefinitionsByNamespace(String modelName, String namespace, Consumer<List<ItemDefinition>> listConsumer) {
        ((DMNIncludedModelsService)this.service.call(this.onSuccess(listConsumer), this.onError(listConsumer))).loadItemDefinitionsByNamespace(this.getWorkspaceProject(), modelName, namespace);
    }

    <T> ErrorCallback<Boolean> onError(Consumer<List<T>> listConsumer) {
        return (message, throwable) -> {
            this.logWarning();
            listConsumer.accept(new ArrayList());
            return false;
        };
    }

    <T> RemoteCallback<List<T>> onSuccess(Consumer<List<T>> listConsumer) {
        return listConsumer::accept;
    }

    private WorkspaceProject getWorkspaceProject() {
        return this.projectContext.getActiveWorkspaceProject().orElse(null);
    }

    private void logWarning() {
        this.warn("[WARNING] DMNIncludeModelsClient could not get the asset list.");
    }

    void warn(String message) {
        DomGlobal.console.warn(new Object[]{message});
    }
}

