/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.context;

import java.util.stream.IntStream;
import org.kie.workbench.common.dmn.api.definition.v1_1.Context;
import org.kie.workbench.common.dmn.api.definition.v1_1.ContextEntry;
import org.kie.workbench.common.dmn.client.commands.VetoExecutionCommand;
import org.kie.workbench.common.dmn.client.commands.VetoUndoCommand;
import org.kie.workbench.common.dmn.client.commands.util.CommandUtils;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.mvp.Command;

public class DeleteContextEntryCommand
extends AbstractCanvasGraphCommand
implements VetoExecutionCommand,
VetoUndoCommand {
    private final Context context;
    private final GridData uiModel;
    private final int uiRowIndex;
    private final Command canvasOperation;
    private final ContextEntry oldContextEntry;
    private final GridRow oldUiModelRow;

    public DeleteContextEntryCommand(Context context, GridData uiModel, int uiRowIndex, Command canvasOperation) {
        this.context = context;
        this.uiModel = uiModel;
        this.uiRowIndex = uiRowIndex;
        this.canvasOperation = canvasOperation;
        this.oldContextEntry = (ContextEntry)context.getContextEntry().get(uiRowIndex);
        this.oldUiModelRow = uiModel.getRow(uiRowIndex);
    }

    protected org.kie.workbench.common.stunner.core.command.Command<GraphCommandExecutionContext, RuleViolation> newGraphCommand(AbstractCanvasHandler handler) {
        return new AbstractGraphCommand(){

            protected CommandResult<RuleViolation> check(GraphCommandExecutionContext gce) {
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> execute(GraphCommandExecutionContext gce) {
                DeleteContextEntryCommand.this.context.getContextEntry().remove(DeleteContextEntryCommand.this.uiRowIndex);
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> undo(GraphCommandExecutionContext gce) {
                DeleteContextEntryCommand.this.context.getContextEntry().add(DeleteContextEntryCommand.this.uiRowIndex, DeleteContextEntryCommand.this.oldContextEntry);
                return GraphCommandResultBuilder.SUCCESS;
            }
        };
    }

    protected org.kie.workbench.common.stunner.core.command.Command<AbstractCanvasHandler, CanvasViolation> newCanvasCommand(AbstractCanvasHandler handler) {
        return new AbstractCanvasCommand(){

            public CommandResult<CanvasViolation> execute(AbstractCanvasHandler handler) {
                DeleteContextEntryCommand.this.uiModel.deleteRow(DeleteContextEntryCommand.this.uiRowIndex);
                DeleteContextEntryCommand.this.updateRowNumbers();
                DeleteContextEntryCommand.this.updateParentInformation();
                DeleteContextEntryCommand.this.canvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }

            public CommandResult<CanvasViolation> undo(AbstractCanvasHandler handler) {
                DeleteContextEntryCommand.this.uiModel.insertRow(DeleteContextEntryCommand.this.uiRowIndex, DeleteContextEntryCommand.this.oldUiModelRow);
                DeleteContextEntryCommand.this.updateRowNumbers();
                DeleteContextEntryCommand.this.updateParentInformation();
                DeleteContextEntryCommand.this.canvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }
        };
    }

    public void updateRowNumbers() {
        CommandUtils.updateRowNumbers(this.uiModel, IntStream.range(0, this.uiModel.getRowCount() - 1));
    }

    public void updateParentInformation() {
        CommandUtils.updateParentInformation(this.uiModel);
    }
}

