/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.dtable;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionRule;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionTable;
import org.kie.workbench.common.dmn.client.commands.VetoExecutionCommand;
import org.kie.workbench.common.dmn.client.commands.VetoUndoCommand;
import org.kie.workbench.common.dmn.client.commands.util.CommandUtils;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionTableUIModelMapperHelper;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.mvp.Command;

public class MoveColumnsCommand
extends AbstractCanvasGraphCommand
implements VetoExecutionCommand,
VetoUndoCommand {
    private final DecisionTable dtable;
    private final DMNGridData uiModel;
    private final int index;
    private final List<GridColumn<?>> columns;
    private final Command canvasOperation;
    private final int oldIndex;

    public MoveColumnsCommand(DecisionTable dtable, DMNGridData uiModel, int index, List<GridColumn<?>> columns, Command canvasOperation) {
        this.dtable = dtable;
        this.uiModel = uiModel;
        this.index = index;
        this.columns = new ArrayList(columns);
        this.canvasOperation = canvasOperation;
        this.oldIndex = uiModel.getColumns().indexOf(columns.get(0));
    }

    protected org.kie.workbench.common.stunner.core.command.Command<GraphCommandExecutionContext, RuleViolation> newGraphCommand(AbstractCanvasHandler context) {
        return new AbstractGraphCommand(){

            protected CommandResult<RuleViolation> check(GraphCommandExecutionContext context) {
                return this.isColumnInValidSection() ? GraphCommandResultBuilder.SUCCESS : GraphCommandResultBuilder.FAILED;
            }

            private boolean isColumnInValidSection() {
                DecisionTableUIModelMapperHelper.DecisionTableSection section = DecisionTableUIModelMapperHelper.getSection(MoveColumnsCommand.this.dtable, MoveColumnsCommand.this.index);
                return section == DecisionTableUIModelMapperHelper.DecisionTableSection.INPUT_CLAUSES || section == DecisionTableUIModelMapperHelper.DecisionTableSection.OUTPUT_CLAUSES;
            }

            public CommandResult<RuleViolation> execute(GraphCommandExecutionContext context) {
                return this.moveClauses(MoveColumnsCommand.this.index);
            }

            public CommandResult<RuleViolation> undo(GraphCommandExecutionContext context) {
                return this.moveClauses(MoveColumnsCommand.this.oldIndex);
            }

            private CommandResult<RuleViolation> moveClauses(int index) {
                DecisionTableUIModelMapperHelper.DecisionTableSection section = DecisionTableUIModelMapperHelper.getSection(MoveColumnsCommand.this.dtable, index);
                if (section == DecisionTableUIModelMapperHelper.DecisionTableSection.INPUT_CLAUSES) {
                    int oldIndex = MoveColumnsCommand.this.uiModel.getColumns().indexOf(MoveColumnsCommand.this.columns.get(0));
                    int relativeIndex = DecisionTableUIModelMapperHelper.getInputEntryIndex(MoveColumnsCommand.this.dtable, index);
                    int relativeOldIndex = DecisionTableUIModelMapperHelper.getInputEntryIndex(MoveColumnsCommand.this.dtable, oldIndex);
                    List<Integer> uiColumnIndexesToMove = MoveColumnsCommand.this.columns.stream().map(c -> MoveColumnsCommand.this.uiModel.getColumns().indexOf(c)).collect(Collectors.toList());
                    List<Integer> inputClauseIndexesToMove = uiColumnIndexesToMove.stream().map(i -> DecisionTableUIModelMapperHelper.getInputEntryIndex(MoveColumnsCommand.this.dtable, i)).collect(Collectors.toList());
                    this.moveClauses(relativeIndex, relativeOldIndex, MoveColumnsCommand.this.dtable.getInput(), inputClauseIndexesToMove);
                    CommandUtils.moveComponentWidths(index, oldIndex, MoveColumnsCommand.this.dtable.getComponentWidths(), uiColumnIndexesToMove);
                    List decisionRulesInputEntries = MoveColumnsCommand.this.dtable.getRule().stream().map(DecisionRule::getInputEntry).collect(Collectors.toList());
                    this.updateDecisionRules(relativeIndex, relativeOldIndex, decisionRulesInputEntries, inputClauseIndexesToMove);
                    return GraphCommandResultBuilder.SUCCESS;
                }
                if (section == DecisionTableUIModelMapperHelper.DecisionTableSection.OUTPUT_CLAUSES) {
                    int oldIndex = MoveColumnsCommand.this.uiModel.getColumns().indexOf(MoveColumnsCommand.this.columns.get(0));
                    int relativeIndex = DecisionTableUIModelMapperHelper.getOutputEntryIndex(MoveColumnsCommand.this.dtable, index);
                    int relativeOldIndex = DecisionTableUIModelMapperHelper.getOutputEntryIndex(MoveColumnsCommand.this.dtable, oldIndex);
                    List<Integer> uiColumnIndexesToMove = MoveColumnsCommand.this.columns.stream().map(c -> MoveColumnsCommand.this.uiModel.getColumns().indexOf(c)).collect(Collectors.toList());
                    List<Integer> outputClauseIndexesToMove = uiColumnIndexesToMove.stream().map(i -> DecisionTableUIModelMapperHelper.getOutputEntryIndex(MoveColumnsCommand.this.dtable, i)).collect(Collectors.toList());
                    this.moveClauses(relativeIndex, relativeOldIndex, MoveColumnsCommand.this.dtable.getOutput(), outputClauseIndexesToMove);
                    CommandUtils.moveComponentWidths(index, oldIndex, MoveColumnsCommand.this.dtable.getComponentWidths(), uiColumnIndexesToMove);
                    List decisionRulesOutputEntries = MoveColumnsCommand.this.dtable.getRule().stream().map(DecisionRule::getOutputEntry).collect(Collectors.toList());
                    this.updateDecisionRules(relativeIndex, relativeOldIndex, decisionRulesOutputEntries, outputClauseIndexesToMove);
                    return GraphCommandResultBuilder.SUCCESS;
                }
                return GraphCommandResultBuilder.FAILED;
            }

            private <T> void moveClauses(int relativeIndex, int relativeOldIndex, List<T> clauses, List<Integer> clauseIndexesToMove) {
                List clausesToMove = clauseIndexesToMove.stream().map(clauses::get).collect(Collectors.toList());
                clauses.removeAll(clausesToMove);
                if (relativeIndex < relativeOldIndex) {
                    clauses.addAll(relativeIndex, clausesToMove);
                } else if (relativeIndex > relativeOldIndex) {
                    clauses.addAll(relativeIndex - clausesToMove.size() + 1, clausesToMove);
                }
            }

            private <T> void updateDecisionRules(int relativeIndex, int relativeOldIndex, List<List<T>> clauses, List<Integer> clauseIndexesToMove) {
                clauses.forEach(row -> this.moveClauses(relativeIndex, relativeOldIndex, (List)row, clauseIndexesToMove));
            }
        };
    }

    protected org.kie.workbench.common.stunner.core.command.Command<AbstractCanvasHandler, CanvasViolation> newCanvasCommand(AbstractCanvasHandler context) {
        return new AbstractCanvasCommand(){

            public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
                MoveColumnsCommand.this.uiModel.moveColumnsTo(MoveColumnsCommand.this.index, MoveColumnsCommand.this.columns);
                MoveColumnsCommand.this.canvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }

            public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
                MoveColumnsCommand.this.uiModel.moveColumnsTo(MoveColumnsCommand.this.oldIndex, MoveColumnsCommand.this.columns);
                MoveColumnsCommand.this.canvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }
        };
    }
}

