/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.function;

import java.util.Optional;
import java.util.function.Supplier;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.api.definition.v1_1.FunctionDefinition;
import org.kie.workbench.common.dmn.client.commands.VetoExecutionCommand;
import org.kie.workbench.common.dmn.client.commands.VetoUndoCommand;
import org.kie.workbench.common.dmn.client.commands.util.CommandUtils;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.KindUtilities;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.model.BaseUIModelMapper;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

public class SetKindCommand
extends AbstractCanvasGraphCommand
implements VetoExecutionCommand,
VetoUndoCommand {
    private final GridCellTuple cellTuple;
    private final FunctionDefinition function;
    private final FunctionDefinition.Kind kind;
    private final Optional<Expression> expression;
    private final ParameterizedCommand<Optional<BaseExpressionGrid<? extends Expression, ? extends GridData, ? extends BaseUIModelMapper>>> executeCanvasOperation;
    private final Command undoCanvasOperation;
    private final Supplier<Optional<BaseExpressionGrid<? extends Expression, ? extends GridData, ? extends BaseUIModelMapper>>> editorSupplier;
    private Optional<BaseExpressionGrid<? extends Expression, ? extends GridData, ? extends BaseUIModelMapper>> editor = Optional.empty();
    private final FunctionDefinition.Kind oldKind;
    private final Optional<Expression> oldExpression;
    private final Optional<GridCellValue<?>> oldCellValue;

    public SetKindCommand(GridCellTuple cellTuple, FunctionDefinition function, FunctionDefinition.Kind kind, Optional<Expression> expression, ParameterizedCommand<Optional<BaseExpressionGrid<? extends Expression, ? extends GridData, ? extends BaseUIModelMapper>>> executeCanvasOperation, Command undoCanvasOperation, Supplier<Optional<BaseExpressionGrid<? extends Expression, ? extends GridData, ? extends BaseUIModelMapper>>> editorSupplier) {
        this.cellTuple = cellTuple;
        this.function = function;
        this.kind = kind;
        this.expression = expression;
        this.executeCanvasOperation = executeCanvasOperation;
        this.undoCanvasOperation = undoCanvasOperation;
        this.editorSupplier = editorSupplier;
        this.oldKind = KindUtilities.getKind(function);
        this.oldExpression = Optional.ofNullable(function.getExpression());
        this.oldCellValue = CommandUtils.extractGridCellValue(cellTuple);
    }

    protected org.kie.workbench.common.stunner.core.command.Command<GraphCommandExecutionContext, RuleViolation> newGraphCommand(AbstractCanvasHandler handler) {
        return new AbstractGraphCommand(){

            protected CommandResult<RuleViolation> check(GraphCommandExecutionContext gce) {
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> execute(GraphCommandExecutionContext gce) {
                KindUtilities.setKind(SetKindCommand.this.function, SetKindCommand.this.kind);
                SetKindCommand.this.function.setExpression((Expression)SetKindCommand.this.expression.orElse(null));
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> undo(GraphCommandExecutionContext gce) {
                KindUtilities.setKind(SetKindCommand.this.function, SetKindCommand.this.oldKind);
                SetKindCommand.this.function.setExpression((Expression)SetKindCommand.this.oldExpression.orElse(null));
                return GraphCommandResultBuilder.SUCCESS;
            }
        };
    }

    protected org.kie.workbench.common.stunner.core.command.Command<AbstractCanvasHandler, CanvasViolation> newCanvasCommand(AbstractCanvasHandler handler) {
        return new AbstractCanvasCommand(){

            public CommandResult<CanvasViolation> execute(AbstractCanvasHandler handler) {
                if (!SetKindCommand.this.editor.isPresent()) {
                    SetKindCommand.this.editor = (Optional)SetKindCommand.this.editorSupplier.get();
                }
                ExpressionCellValue value = new ExpressionCellValue(SetKindCommand.this.editor);
                GridData gridData = SetKindCommand.this.cellTuple.getGridWidget().getModel();
                gridData.setCellValue(SetKindCommand.this.cellTuple.getRowIndex(), SetKindCommand.this.cellTuple.getColumnIndex(), (GridCellValue)value);
                SetKindCommand.this.executeCanvasOperation.execute((Object)SetKindCommand.this.editor);
                return CanvasCommandResultBuilder.SUCCESS;
            }

            public CommandResult<CanvasViolation> undo(AbstractCanvasHandler handler) {
                if (SetKindCommand.this.oldCellValue.isPresent()) {
                    SetKindCommand.this.cellTuple.getGridWidget().getModel().setCellValue(SetKindCommand.this.cellTuple.getRowIndex(), SetKindCommand.this.cellTuple.getColumnIndex(), (GridCellValue)SetKindCommand.this.oldCellValue.get());
                } else {
                    SetKindCommand.this.cellTuple.getGridWidget().getModel().deleteCell(SetKindCommand.this.cellTuple.getRowIndex(), SetKindCommand.this.cellTuple.getColumnIndex());
                }
                SetKindCommand.this.undoCanvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }
        };
    }
}

