/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.relation;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem;
import org.kie.workbench.common.dmn.api.definition.v1_1.Relation;
import org.kie.workbench.common.dmn.client.commands.VetoExecutionCommand;
import org.kie.workbench.common.dmn.client.commands.VetoUndoCommand;
import org.kie.workbench.common.dmn.client.commands.util.CommandUtils;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationUIModelMapper;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.mvp.Command;

public class DeleteRelationColumnCommand
extends AbstractCanvasGraphCommand
implements VetoExecutionCommand,
VetoUndoCommand {
    private final Relation relation;
    private final GridData uiModel;
    private final int uiColumnIndex;
    private final RelationUIModelMapper uiModelMapper;
    private final Command executeCanvasOperation;
    private final Command undoCanvasOperation;
    private final InformationItem oldInformationItem;
    private final List<Expression> oldColumnData;
    private final GridColumn<?> oldUiModelColumn;

    public DeleteRelationColumnCommand(Relation relation, GridData uiModel, int uiColumnIndex, RelationUIModelMapper uiModelMapper, Command executeCanvasOperation, Command undoCanvasOperation) {
        this.relation = relation;
        this.uiModel = uiModel;
        this.uiColumnIndex = uiColumnIndex;
        this.uiModelMapper = uiModelMapper;
        this.executeCanvasOperation = executeCanvasOperation;
        this.undoCanvasOperation = undoCanvasOperation;
        this.oldInformationItem = (InformationItem)relation.getColumn().get(uiColumnIndex - 1);
        this.oldColumnData = this.extractColumnData(uiColumnIndex);
        this.oldUiModelColumn = (GridColumn)uiModel.getColumns().get(uiColumnIndex);
    }

    private List<Expression> extractColumnData(int uiColumnIndex) {
        int iiIndex = uiColumnIndex - 1;
        return this.relation.getRow().stream().map(row -> (Expression)row.getExpression().get(iiIndex)).collect(Collectors.toList());
    }

    protected org.kie.workbench.common.stunner.core.command.Command<GraphCommandExecutionContext, RuleViolation> newGraphCommand(AbstractCanvasHandler handler) {
        return new AbstractGraphCommand(){

            protected CommandResult<RuleViolation> check(GraphCommandExecutionContext gce) {
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> execute(GraphCommandExecutionContext gce) {
                DeleteRelationColumnCommand.this.relation.getComponentWidths().remove(DeleteRelationColumnCommand.this.uiColumnIndex);
                int iiIndex = DeleteRelationColumnCommand.this.uiColumnIndex - 1;
                DeleteRelationColumnCommand.this.relation.getRow().forEach(row -> {
                    Expression cfr_ignored_0 = (Expression)row.getExpression().remove(iiIndex);
                });
                DeleteRelationColumnCommand.this.relation.getColumn().remove(iiIndex);
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> undo(GraphCommandExecutionContext gce) {
                DeleteRelationColumnCommand.this.relation.getComponentWidths().add(DeleteRelationColumnCommand.this.uiColumnIndex, DeleteRelationColumnCommand.this.oldUiModelColumn.getWidth());
                int iiIndex = DeleteRelationColumnCommand.this.uiColumnIndex - 1;
                DeleteRelationColumnCommand.this.relation.getColumn().add(iiIndex, DeleteRelationColumnCommand.this.oldInformationItem);
                IntStream.range(0, DeleteRelationColumnCommand.this.relation.getRow().size()).forEach(rowIndex -> {
                    Expression value = (Expression)DeleteRelationColumnCommand.this.oldColumnData.get(rowIndex);
                    ((org.kie.workbench.common.dmn.api.definition.v1_1.List)DeleteRelationColumnCommand.this.relation.getRow().get(rowIndex)).getExpression().add(iiIndex, value);
                });
                return GraphCommandResultBuilder.SUCCESS;
            }
        };
    }

    protected org.kie.workbench.common.stunner.core.command.Command<AbstractCanvasHandler, CanvasViolation> newCanvasCommand(AbstractCanvasHandler handler) {
        return new AbstractCanvasCommand(){

            public CommandResult<CanvasViolation> execute(AbstractCanvasHandler handler) {
                GridColumn gridColumn = (GridColumn)DeleteRelationColumnCommand.this.uiModel.getColumns().get(DeleteRelationColumnCommand.this.uiColumnIndex);
                DeleteRelationColumnCommand.this.uiModel.deleteColumn(gridColumn);
                DeleteRelationColumnCommand.this.updateParentInformation();
                DeleteRelationColumnCommand.this.executeCanvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }

            public CommandResult<CanvasViolation> undo(AbstractCanvasHandler handler) {
                DeleteRelationColumnCommand.this.uiModel.insertColumn(DeleteRelationColumnCommand.this.uiColumnIndex, DeleteRelationColumnCommand.this.oldUiModelColumn);
                for (int rowIndex = 0; rowIndex < DeleteRelationColumnCommand.this.relation.getRow().size(); ++rowIndex) {
                    DeleteRelationColumnCommand.this.uiModelMapper.fromDMNModel(rowIndex, DeleteRelationColumnCommand.this.uiColumnIndex);
                }
                DeleteRelationColumnCommand.this.updateParentInformation();
                DeleteRelationColumnCommand.this.undoCanvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }
        };
    }

    public void updateParentInformation() {
        CommandUtils.updateParentInformation(this.uiModel);
    }
}

